/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.expressions;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestInMemoryScalarExpressions
extends AbstractTestCase {
    private int userid1;
    private int userid2;
    private int userid3;
    private int userid4;
    private int userid5;
    private int userid6;

    public TestInMemoryScalarExpressions(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(CompUser.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Address[] add = new Address[]{new Address("43 Sansome", "SF", "United-Kingdom", "94104"), new Address("24 Mink", "ANTIOCH", "USA", "94513"), new Address("23 Ogbete", "CoalCamp", "NIGERIA", "00000"), new Address("10 Wilshire", "Worcester", "CANADA", "80080"), new Address("23 Bellflower", "Ogui", null, "02000"), new Address("22 Montgomery", "SF", null, "50054")};
        CompUser user1 = this.createUser("Seetha", "MAC", add[0], 36, true);
        CompUser user2 = this.createUser("Shannon ", "PC", add[1], 36, false);
        CompUser user3 = this.createUser("Ugo", "PC", add[2], 19, true);
        CompUser user4 = this.createUser("_Jacob", "LINUX", add[3], 10, true);
        CompUser user5 = this.createUser("Famzy", "UNIX", add[4], 29, false);
        CompUser user6 = this.createUser("Shade", "UNIX", add[5], 23, false);
        em.persist((Object)user1);
        this.userid1 = user1.getUserid();
        em.persist((Object)user2);
        this.userid2 = user2.getUserid();
        em.persist((Object)user3);
        this.userid3 = user3.getUserid();
        em.persist((Object)user4);
        this.userid4 = user4.getUserid();
        em.persist((Object)user5);
        this.userid5 = user5.getUserid();
        em.persist((Object)user6);
        this.userid6 = user6.getUserid();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCoalesceExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List rsall = em.createQuery("SELECT e from CompUser e").getResultList();
        String query = "SELECT e.name as name,  COALESCE (e.address.country, 'Unknown') FROM CompUser e ORDER BY name";
        QueryImpl q1 = (QueryImpl)em.createQuery(query);
        Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        qi.setCandidateCollection((Collection)rsall);
        List rs = q1.getResultList();
        Object[] result = (Object[])rs.get(0);
        TestInMemoryScalarExpressions.assertEquals((String)"the name is not famzy", (Object)"Famzy", (Object)result[0]);
        TestInMemoryScalarExpressions.assertEquals((Object)"Unknown", (Object)result[1]);
        this.endEm((EntityManager)em);
    }

    public void testNullIfExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List rsall = em.createQuery("SELECT e from CompUser e").getResultList();
        String query = "SELECT e.name,   NULLIF (e.address.country, 'USA'),  e.address.country as res  FROM CompUser e ORDER BY res";
        QueryImpl q1 = (QueryImpl)em.createQuery(query);
        Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        qi.setCandidateCollection((Collection)rsall);
        List rs = q1.getResultList();
        Object[] result = (Object[])rs.get(2);
        TestInMemoryScalarExpressions.assertEquals((String)"the name is not shannon ", (Object)"Shannon ", (Object)result[0]);
        TestInMemoryScalarExpressions.assertNull((String)"is not null", (Object)result[1]);
        this.endEm((EntityManager)em);
    }

    public void testSimpleCaseExpression() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List rsall = em.createQuery("SELECT e from CompUser e").getResultList();
        String query = "SELECT e.name,  CASE e.address.country WHEN 'USA'  THEN 'us'  ELSE 'non-us'  END as d2,  e.address.country  FROM CompUser e order by d2";
        QueryImpl q1 = (QueryImpl)em.createQuery(query);
        Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        qi.setCandidateCollection((Collection)rsall);
        List rs = q1.getResultList();
        Object[] result = (Object[])rs.get(5);
        TestInMemoryScalarExpressions.assertEquals((String)"the name is not shannon ", (Object)"Shannon ", (Object)result[0]);
        TestInMemoryScalarExpressions.assertEquals((String)"is not 'us'", (Object)"us", (Object)result[1]);
        this.endEm((EntityManager)em);
    }

    public void testGeneralCaseExpression() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List rsall = em.createQuery("SELECT e from CompUser e").getResultList();
        String query = "SELECT e.name as name,  CASE WHEN e.age > 30 THEN  30  WHEN e.age < 15 THEN  15  ELSE 20  END,  e.age  FROM CompUser e ORDER BY name";
        QueryImpl q1 = (QueryImpl)em.createQuery(query);
        Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        qi.setCandidateCollection((Collection)rsall);
        List rs = q1.getResultList();
        Object[] result = (Object[])rs.get(3);
        TestInMemoryScalarExpressions.assertEquals((String)"the name is not shannon ", (Object)"Shannon ", (Object)result[0]);
        TestInMemoryScalarExpressions.assertEquals((String)"not 30", (String)"30", (String)result[1].toString());
        this.endEm((EntityManager)em);
    }

    public CompUser createUser(String name, String cName, Address add, int age, boolean isMale) {
        CompUser user = null;
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        }
        return user;
    }
}

