/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.expressions;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEntityTypeExpression
extends AbstractTestCase {
    private int userid1;
    private int userid2;
    private int userid3;
    private int userid4;
    private int userid5;
    private int userid6;

    public TestEntityTypeExpression(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(CompUser.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Address[] add = new Address[]{new Address("43 Sansome", "SF", "United-Kingdom", "94104"), new Address("24 Mink", "ANTIOCH", "USA", "94513"), new Address("23 Ogbete", "CoalCamp", "NIGERIA", "00000"), new Address("10 Wilshire", "Worcester", "CANADA", "80080"), new Address("23 Bellflower", "Ogui", null, "02000"), new Address("22 Montgomery", "SF", null, "50054")};
        CompUser user1 = this.createUser("Seetha", "MAC", add[0], 36, true);
        CompUser user2 = this.createUser("Shannon", "PC", add[1], 36, false);
        CompUser user3 = this.createUser("Ugo", "PC", add[2], 19, true);
        CompUser user4 = this.createUser("Jacob", "LINUX", add[3], 10, true);
        CompUser user5 = this.createUser("Famzy", "UNIX", add[4], 29, false);
        CompUser user6 = this.createUser("Shade", "UNIX", add[5], 23, false);
        em.persist((Object)user1);
        this.userid1 = user1.getUserid();
        em.persist((Object)user2);
        this.userid2 = user2.getUserid();
        em.persist((Object)user3);
        this.userid3 = user3.getUserid();
        em.persist((Object)user4);
        this.userid4 = user4.getUserid();
        em.persist((Object)user5);
        this.userid5 = user5.getUserid();
        em.persist((Object)user6);
        this.userid6 = user6.getUserid();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testTypeExpression() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = null;
        List rs = null;
        CompUser user = null;
        ArrayList<Class> params = new ArrayList<Class>(2);
        params.add(FemaleUser.class);
        params.add(MaleUser.class);
        ArrayList<Integer> params2 = new ArrayList<Integer>(3);
        params2.add(36);
        params2.add(29);
        params2.add(19);
        String param3 = "PC";
        query = "SELECT e FROM CompUser e where TYPE(e) in ?1 and e.age in ?2 and e.computerName = ?3 ORDER By e.name";
        rs = em.createQuery(query).setParameter(1, params).setParameter(2, params2).setParameter(3, (Object)param3).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Shannon", (String)user.getName());
        query = "SELECT e FROM CompUser e where TYPE(e) in ?1 and e.age in ?2 ORDER By e.name";
        rs = em.createQuery(query).setParameter(1, params).setParameter(2, params2).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Famzy", (String)user.getName());
        query = "SELECT e FROM CompUser e where TYPE(e) in :value ORDER BY e.age";
        rs = em.createQuery(query).setParameter("value", params).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Jacob", (String)user.getName());
        query = "SELECT TYPE(e) FROM MaleUser e where TYPE(e) = MaleUser";
        rs = em.createQuery(query).getResultList();
        Object type = rs.get(0);
        TestEntityTypeExpression.assertEquals(type, MaleUser.class);
        query = "SELECT TYPE(e) FROM CompUser e where TYPE(e) = ?1";
        rs = em.createQuery(query).setParameter(1, FemaleUser.class).getResultList();
        type = rs.get(0);
        TestEntityTypeExpression.assertEquals(type, FemaleUser.class);
        query = "SELECT TYPE(e) FROM MaleUser e where TYPE(e) = ?1";
        rs = em.createQuery(query).setParameter(1, MaleUser.class).getResultList();
        type = rs.get(0);
        TestEntityTypeExpression.assertEquals(type, MaleUser.class);
        query = "SELECT e, FemaleUser, a FROM Address a, FemaleUser e  where e.address IS NOT NULL";
        List rs2 = em.createQuery(query).getResultList();
        type = ((Object[])rs2.get(0))[1];
        TestEntityTypeExpression.assertEquals(type, FemaleUser.class);
        query = "SELECT e FROM CompUser e where TYPE(e) = :type  ORDER BY e.name";
        rs = em.createQuery(query).setParameter("type", FemaleUser.class).getResultList();
        TestEntityTypeExpression.assertTrue((rs.size() == 3 ? 1 : 0) != 0);
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Famzy", (String)user.getName());
        user = (CompUser)rs.get(1);
        TestEntityTypeExpression.assertEquals((String)"Shade", (String)user.getName());
        user = (CompUser)rs.get(2);
        TestEntityTypeExpression.assertEquals((String)"Shannon", (String)user.getName());
        query = "SELECT e FROM CompUser e where TYPE(e) = ?1 ORDER BY e.name";
        rs = em.createQuery(query).setParameter(1, FemaleUser.class).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Famzy", (String)user.getName());
        query = "SELECT e FROM CompUser e where TYPE(e) in (?1) ORDER BY e.name DESC";
        rs = em.createQuery(query).setParameter(1, MaleUser.class).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Ugo", (String)user.getName());
        query = "SELECT e FROM CompUser e where TYPE(e) in (?1, ?2) ORDER BY e.name DESC";
        rs = em.createQuery(query).setParameter(1, FemaleUser.class).setParameter(2, MaleUser.class).getResultList();
        user = (CompUser)rs.get(0);
        TestEntityTypeExpression.assertEquals((String)"Ugo", (String)user.getName());
        query = "select sum(e.age) FROM CompUser e GROUP BY e.age HAVING ABS(e.age) = :param";
        Long sum = (Long)em.createQuery(query).setParameter("param", (Object)new Double(36.0)).getSingleResult();
        TestEntityTypeExpression.assertEquals((int)sum.intValue(), (int)72);
        String[] queries = new String[]{"SELECT e FROM CompUser e where TYPE(e) = MaleUser", "SELECT e from CompUser e where TYPE(e) in (FemaleUser)", "SELECT e from CompUser e where TYPE(e) not in (FemaleUser)", "SELECT e from CompUser e where TYPE(e) in (MaleUser, FemaleUser)", "SELECT TYPE(e) FROM CompUser e where TYPE(e) = MaleUser", "SELECT TYPE(e) FROM CompUser e", "SELECT TYPE(a.user) FROM Address a", "SELECT MaleUser FROM CompUser e", "SELECT MaleUser FROM Address a", "SELECT  CASE TYPE(e) WHEN FemaleUser THEN 'Female'  ELSE 'Male'  END  FROM CompUser e"};
        for (int i = 0; i < queries.length; ++i) {
            query = queries[i];
            List rs1 = em.createQuery(query).getResultList();
            Object obj = rs1.get(0);
            obj.toString();
        }
        this.endEm((EntityManager)em);
    }

    public CompUser createUser(String name, String cName, Address add, int age, boolean isMale) {
        CompUser user = null;
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        }
        return user;
    }
}

