/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import org.apache.openjpa.persistence.jpql.entities.IColumnEntity;
import org.apache.openjpa.persistence.jpql.entities.IOrderedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class OrderedNameEntity
implements IColumnEntity,
Serializable {
    @Id
    private int id;
    private String name;
    @ManyToMany
    @OrderColumn
    private List<IOrderedEntity> entities;

    public OrderedNameEntity() {
    }

    public OrderedNameEntity(String name) {
        this.id = name.charAt(0) - 65 + 1;
        this.name = name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "OrderedNameEntity[" + this.id + "]=" + this.name;
    }

    @Override
    public List<IOrderedEntity> getEntities() {
        return this.entities;
    }

    @Override
    public void setEntities(List<IOrderedEntity> entities) {
        this.entities = entities;
    }

    @Override
    public void addEntity(IOrderedEntity entity) {
        if (this.entities == null) {
            this.entities = new ArrayList<IOrderedEntity>();
        }
        this.entities.add(entity);
    }

    @Override
    public IOrderedEntity removeEntity(IOrderedEntity entity) {
        IOrderedEntity rtnVal = null;
        if (this.entities != null && this.entities.remove(entity)) {
            rtnVal = entity;
        }
        return rtnVal;
    }
}

