/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.clauses;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.ArtCourse;
import org.apache.openjpa.persistence.common.apps.Course;
import org.apache.openjpa.persistence.common.apps.Department;
import org.apache.openjpa.persistence.common.apps.Student;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBClauses
extends AbstractTestCase {
    public TestEJBClauses(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(Course.class);
        this.deleteAll(Student.class);
        this.deleteAll(Department.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String name = "";
        ArrayList<Course> clist = new ArrayList<Course>();
        ArrayList<Department> dlist = new ArrayList<Department>();
        for (int i = 0; i < 5; ++i) {
            Course curr = new Course("Math " + i, i * 2, i);
            ArtCourse acurr = new ArtCourse(i + 20, "English" + 2 * i);
            Department durr = new Department("CompSci" + i, null, i + 2);
            clist.add(curr);
            clist.add(acurr);
            dlist.add(durr);
        }
        Student stud = new Student("Jonathan", clist, dlist);
        Student stud2 = new Student("Stam", null, dlist);
        Student stud3 = new Student("John", clist, null);
        Student stud4 = new Student("Bill", null, null);
        em.persist((Object)stud);
        em.persist((Object)stud2);
        em.persist((Object)stud3);
        em.persist((Object)stud4);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testFromClause1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM Student o";
        List result = em.createQuery(query).getResultList();
        TestEJBClauses.assertNotNull((Object)result);
        TestEJBClauses.assertEquals((int)4, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testFromClause2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT NEW apps.ArtCourse(e.name)FROM Student e";
        List result = em.createQuery(query).getResultList();
        TestEJBClauses.assertNotNull((Object)result);
        TestEJBClauses.assertEquals((int)4, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testFromClause3() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM Student o, Course c WHERE o.course IS NULL AND o.department IS NULL";
        List ls = em.createQuery(query).getResultList();
        String uno = (String)ls.get(0);
        TestEJBClauses.assertNotNull((Object)ls);
        TestEJBClauses.assertEquals((int)1, (int)ls.size());
        TestEJBClauses.assertEquals((String)"Bill", (String)uno);
        this.endEm((EntityManager)em);
    }

    public void testWhereClause1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT distinct s.name FROM Student s, Course d WHERE d.courseId >= 4 AND s.department IS NOT NULL";
        List ls = em.createQuery(query).getResultList();
        TestEJBClauses.assertNotNull((Object)ls);
        TestEJBClauses.assertEquals((int)2, (int)ls.size());
        this.endEm((EntityManager)em);
    }

    public void testWhereClause2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT distinct s.name FROM Student s WHERE Exists(SELECT c FROM s.course c WHERE c.name LIKE 'Math%')";
        List ls = em.createQuery(query).getResultList();
        TestEJBClauses.assertNotNull((Object)ls);
        TestEJBClauses.assertEquals((int)2, (int)ls.size());
        TestEJBClauses.assertTrue((boolean)ls.contains("Jonathan"));
        TestEJBClauses.assertTrue((boolean)ls.contains("John"));
        this.endEm((EntityManager)em);
    }

    public void testClauseRangeVar() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT DISTINCT s FROM Student s, Student s2 WHERE s.name = 'John' AND s2.name = 'Jonathan'";
        List ls = em.createQuery(query).getResultList();
        TestEJBClauses.assertNotNull((Object)ls);
        TestEJBClauses.assertEquals((int)1, (int)ls.size());
        Student ret = (Student)ls.get(0);
        TestEJBClauses.assertEquals((String)"John", (String)ret.getName());
        this.endEm((EntityManager)em);
    }

    public void testClausePathExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String failure = "SELECT DISTINCT s FROM Student s WHERE s.department.name = 'CompSci1'";
        List ls = em.createQuery(failure).getResultList();
        TestEJBClauses.assertFalse((boolean)ls.isEmpty());
        this.endEm((EntityManager)em);
    }

    public void testClausePathExpr2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String success = "SELECT DISTINCT d.name FROM Student AS s, IN(s.department) d ";
        List ls2 = em.createQuery(success).getResultList();
        TestEJBClauses.assertNotNull((Object)ls2);
        TestEJBClauses.assertEquals((int)5, (int)ls2.size());
        this.endEm((EntityManager)em);
    }

    public void testCollMemberDecl() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String colldec = "SELECT DISTINCT s.name FROM Student s, IN(s.department) d WHERE d.name = 'CompSci2'";
        List ls = em.createQuery(colldec).getResultList();
        TestEJBClauses.assertNotNull((Object)ls);
        TestEJBClauses.assertEquals((int)2, (int)ls.size());
        TestEJBClauses.assertTrue((boolean)ls.contains("Jonathan"));
        TestEJBClauses.assertTrue((boolean)ls.contains("Stam"));
        this.endEm((EntityManager)em);
    }
}

