/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.clauses;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.Entity1;
import org.apache.openjpa.persistence.common.apps.Entity2;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestBulkUpdate
extends AbstractTestCase {
    public TestBulkUpdate(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(Entity1.class);
        this.deleteAll(Entity2.class);
    }

    public void testSimpleBulkUpdate() {
        for (int i = 1; i < 5; ++i) {
            this.testSimpleBulkUpdate(i);
        }
    }

    public void testSimpleBulkUpdate(int num) {
        this.deleteAll(Entity1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        for (int i = 0; i < num; ++i) {
            Entity1 e = new Entity1(i, "value1", i);
            em.persist((Object)e);
        }
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query updateQuery1 = em.createQuery("update Entity1 e set e.stringField = 'value2', e.intField = 2 where e.stringField = :val").setParameter("val", (Object)"value1");
        TestBulkUpdate.assertEquals((int)num, (int)updateQuery1.executeUpdate());
        TestBulkUpdate.assertEquals((int)0, (int)updateQuery1.executeUpdate());
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query updateQuery2 = em.createQuery("update Entity1 e set e.stringField = :newval where e.stringField = :val").setParameter("val", (Object)"value2").setParameter("newval", (Object)"value3");
        TestBulkUpdate.assertEquals((int)num, (int)updateQuery2.executeUpdate());
        TestBulkUpdate.assertEquals((int)0, (int)updateQuery2.executeUpdate());
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query updateQuery3 = em.createQuery("update Entity1 e set e.stringField = :newval, e.intField = 999 where e.stringField = :val").setParameter("val", (Object)"value3").setParameter("newval", (Object)"value4");
        TestBulkUpdate.assertEquals((int)num, (int)updateQuery3.executeUpdate());
        TestBulkUpdate.assertEquals((int)0, (int)updateQuery3.executeUpdate());
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query updateQuery4 = em.createQuery("update Entity1 e set e.stringField = :nullval, e.intField = :intval where e.stringField = :val and e.intField = 999").setParameter("val", (Object)"value4").setParameter("intval", (Object)new Integer(987)).setParameter("nullval", null);
        TestBulkUpdate.assertEquals((int)num, (int)updateQuery4.executeUpdate());
        TestBulkUpdate.assertEquals((int)0, (int)updateQuery4.executeUpdate());
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query updateFieldValue = em.createQuery("update Entity1 e set e.intField = e.intField + 1");
        TestBulkUpdate.assertEquals((int)num, (int)updateFieldValue.executeUpdate());
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        Query deleteQuery = em.createQuery("delete from Entity1 e where e.stringField = :val").setParameter("val", null);
        TestBulkUpdate.assertEquals((int)num, (int)deleteQuery.executeUpdate());
        TestBulkUpdate.assertEquals((int)0, (int)deleteQuery.executeUpdate());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

