/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.update;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.jdbc.update.Child;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Parent {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    private Collection<Child> children;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Child> getChildren() {
        return this.children;
    }

    public Child newChild(String name) {
        Child child = new Child();
        child.setName(name);
        child.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<Child>();
        }
        this.children.add(child);
        return child;
    }

    public boolean removeChild(Child child) {
        return this.children != null && this.children.remove(child);
    }

    public void add(Child child) {
        if (this.children == null) {
            this.children = new ArrayList<Child>();
        }
        this.children.add(child);
    }
}

