/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.unique;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.jdbc.unique.UniqueA;
import org.apache.openjpa.persistence.jdbc.unique.UniqueB;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUniqueConstraintWithXMLDescriptor
extends SQLListenerTestCase {
    @Override
    public void setUp(Object ... props) {
        super.setUp(DROP_TABLES, UniqueA.class, UniqueB.class);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "test-unique-constraint";
    }

    public void testMapping() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
        List<String> sqls = this.sql;
        TestUniqueConstraintWithXMLDescriptor.assertFalse((String)"No SQL DDL registered", (boolean)sqls.isEmpty());
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_A_XML", "UNIQUE .*\\(f1x, f2x\\)", "UNIQUE .*\\(f3x, f4x\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_B_XML", "UNIQUE .*\\(f1x, f2x\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_SECONDARY_XML", "UNIQUE .*\\(sf1x\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_GENERATOR_XML", "UNIQUE .*\\(GEN1_XML, GEN2_XML\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_JOINTABLE_XML", "UNIQUE .*\\(FK_A_XML, FK_B_XML\\)");
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestUniqueConstraintWithXMLDescriptor.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }
}

