/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.TestCase;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.OpenJPAPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestExternalizedParameter
extends TestCase {
    private static String RESOURCE = "META-INF/persistence.xml";
    private static String UNIT_NAME = "PreparedQuery";
    private static EntityManagerFactory emf;

    public void setUp() throws Exception {
        if (emf == null) {
            Properties config = new Properties();
            config.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
            config.put("openjpa.jdbc.QuerySQLCache", "true");
            config.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            config.put("openjpa.DynamicEnhancementAgent", "false");
            config.put("openjpa.Log", "SQL=WARN");
            emf = OpenJPAPersistence.createEntityManagerFactory((String)UNIT_NAME, (String)RESOURCE, (Map)config);
        }
    }

    public void testNoFalseAlarmOnExternalizedParameterDetection() {
        String jpql = "select b from Book b where b.title=:title";
        EntityManager em = emf.createEntityManager();
        QueryExpressions[] exps = this.getExpressions(em.createQuery(jpql).setParameter("title", (Object)"XYZ").getResultList());
        TestExternalizedParameter.assertNotNull((Object)exps);
        TestExternalizedParameter.assertFalse((boolean)this.isUsingExternalizedParameter(exps[0]));
    }

    public void testCanDetectExternalizedSingleParameterValue() {
        String jpql = "select b from Book b where b.token=:token";
        EntityManager em = emf.createEntityManager();
        QueryExpressions[] exps = this.getExpressions(em.createQuery(jpql).setParameter("token", (Object)"MEDIUM").getResultList());
        TestExternalizedParameter.assertNotNull((Object)exps);
        TestExternalizedParameter.assertTrue((boolean)this.isUsingExternalizedParameter(exps[0]));
    }

    public void testCanDetectExternalizedMixedParameterValue() {
        String jpql = "select b from Book b where b.token=:token and b.title = :title";
        EntityManager em = emf.createEntityManager();
        QueryExpressions[] exps = this.getExpressions(em.createQuery(jpql).setParameter("token", (Object)"MEDIUM").setParameter("token", (Object)"LARGE").getResultList());
        TestExternalizedParameter.assertNotNull((Object)exps);
        TestExternalizedParameter.assertTrue((boolean)this.isUsingExternalizedParameter(exps[0]));
    }

    public QueryExpressions[] getExpressions(List<?> result) {
        Object userObject = ((ResultList)result).getUserObject();
        if (userObject == null || !userObject.getClass().isArray() || ((Object[])userObject).length != 2) {
            return null;
        }
        Object executor = ((Object[])userObject)[1];
        if (!(executor instanceof StoreQuery.Executor)) {
            return null;
        }
        return ((StoreQuery.Executor)executor).getQueryExpressions();
    }

    boolean isUsingExternalizedParameter(QueryExpressions exp) {
        List fmds = exp.getParameterizedFields();
        for (FieldMetaData fmd : fmds) {
            if (!fmd.isExternalized()) continue;
            return true;
        }
        return false;
    }
}

