/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.Collection;
import java.util.HashSet;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.jdbc.sqlcache.Department;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="COMPANY_PQC")
@NamedQueries(value={@NamedQuery(name="Company.PreparedQueryWithNoParameter", query="select x from Company x"), @NamedQuery(name="Company.PreparedQueryWithNamedParameter", query="select x from Company x where x.name=:name and x.startYear=:startYear"), @NamedQuery(name="Company.PreparedQueryWithPositionalParameter", query="select x from Company x where x.name=?1 and x.startYear=?2"), @NamedQuery(name="Company.PreparedQueryWithLiteral", query="select x from Company x where x.name='IBM' and x.startYear=1900")})
public class Company {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    private int startYear;
    @OneToMany(mappedBy="company", cascade={CascadeType.ALL})
    private Collection<Department> departments = new HashSet<Department>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Department> getDepartments() {
        return this.departments;
    }

    public void addDepartment(Department dept) {
        this.departments.add(dept);
        dept.setCompany(this);
    }

    public long getId() {
        return this.id;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }
}

