/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import org.apache.openjpa.persistence.ExternalValues;
import org.apache.openjpa.persistence.jdbc.sqlcache.Author;
import org.apache.openjpa.persistence.jdbc.sqlcache.Merchandise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="BOOK")
public class Book
extends Merchandise {
    private String title;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<Author> authors;
    @ExternalValues(value={"SMALL=S", "MEDIUM=M", "LARGE=L"})
    private String token;

    public Book() {
        this("?");
        this.token = "MEDIUM";
    }

    public Book(String title) {
        this.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Set<Author> getAuthors() {
        return this.authors;
    }

    public void addAuthor(Author a) {
        if (this.authors == null) {
            this.authors = new HashSet<Author>();
        }
        if (this.authors.add(a)) {
            a.addBook(this);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String t) {
        this.token = t;
    }
}

