/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestSchemaGenerator
extends BaseJDBCTest {
    public TestSchemaGenerator(String name) {
        super(name);
    }

    public void DBMetadataTest() throws Exception {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        Object cm = null;
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        DataSource ds = conf.getDataSource2(null);
        Connection c = ds.getConnection();
        DatabaseMetaData meta = c.getMetaData();
        DBDictionary dict = conf.getDBDictionaryInstance();
        String schema = cm.getTable().getSchema().getName();
        Table[] tables = dict.getTables(meta, c.getCatalog(), schema, cm.getTable().getName(), c);
        TestSchemaGenerator.assertEquals((int)1, (int)tables.length);
        Column[] columns = dict.getColumns(meta, c.getCatalog(), schema, cm.getTable().getName(), null, c);
        for (int i = 0; i < columns.length; ++i) {
            System.out.println("### " + columns[i].getName());
        }
    }

    public void testSchemaGen() throws Exception {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        OpenJPAEntityManager pm = pmf.createEntityManager();
        JDBCConfiguration con = (JDBCConfiguration)((OpenJPAEntityManagerSPI)pm).getConfiguration();
        DBDictionary dict = con.getDBDictionaryInstance();
        MappingRepository repos = con.getMappingRepositoryInstance();
        ClassMapping cm = repos.getMapping(RuntimeTest1.class, pm.getClassLoader(), true);
        String schemas = cm.getTable().getSchema().getName();
        if (schemas == null) {
            schemas = "";
        }
        schemas = schemas + "." + cm.getTable().getName();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.jdbc.Schemas", schemas);
        OpenJPAEntityManagerFactory kpmf = this.getEmf(props);
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)kpmf).getConfiguration();
        StringWriter sw = new StringWriter();
        SchemaTool.Flags flags = new SchemaTool.Flags();
        flags.writer = sw;
        flags.primaryKeys = true;
        flags.foreignKeys = true;
        flags.indexes = true;
        flags.openjpaTables = true;
        flags.action = "reflect";
        SchemaTool.run((JDBCConfiguration)conf, (String[])new String[0], (SchemaTool.Flags)flags, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        sw.flush();
        String data = sw.toString();
        TestSchemaGenerator.assertTrue((data.length() > 0 ? 1 : 0) != 0);
    }
}

