/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.ClassTableJDBCSeq;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.jdbc.common.apps.PerClassTestObject3;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqD;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqE;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestClassDBSequenceFactory
extends BaseJDBCTest {
    public TestClassDBSequenceFactory() {
    }

    public TestClassDBSequenceFactory(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(SeqE.class);
    }

    boolean supportsPessimisticLocking() {
        OpenJPAConfiguration conf = this.getConfiguration();
        return conf instanceof JDBCConfiguration && ((JDBCConfiguration)conf).getDBDictionaryInstance().supportsSelectForUpdate;
    }

    public void testVirtualSuperclass() {
        OpenJPAEntityManagerFactory pmf = this.getEmf(this.getProps());
        OpenJPAEntityManager pm = pmf.createEntityManager();
        Object gen = null;
        long next = ((Number)gen.getIncrement()).longValue();
        TestClassDBSequenceFactory.assertEquals((long)(next + 1L), (long)((Number)gen.getIncrement()).longValue());
        pm.close();
        pmf.close();
    }

    public void testIgnoreVirtualSuperclass() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("TableName", "JDO_CLASS_SEQUENCE");
        props.put("IgnoreVirtual", "true");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        Object gen = null;
        long next = ((Number)gen.getIncrement()).longValue();
        Object gen2 = null;
        long next2 = ((Number)gen2.getIncrement()).longValue();
        if (next2 != next + 1L) {
            return;
        }
        TestClassDBSequenceFactory.assertTrue((((Number)gen.getIncrement()).longValue() != next2 + 1L ? 1 : 0) != 0);
        pm.close();
        pmf.close();
    }

    public void testNoSequenceHolesOnAttach() {
        PerClassTestObject3 pc = new PerClassTestObject3();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        long id1 = pc.getId();
        pc = new PerClassTestObject3();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        long id2 = pc.getId();
        this.endTx((EntityManager)pm);
        pm.close();
        pc = new PerClassTestObject3();
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        long id3 = pc.getId();
        pm.close();
        TestClassDBSequenceFactory.assertEquals((long)(id1 + 1L), (long)id2);
        TestClassDBSequenceFactory.assertEquals((long)(id2 + 1L), (long)id3);
    }

    public void testSequence() throws Exception {
        if (!this.supportsPessimisticLocking()) {
            return;
        }
        HashSet set = new HashSet();
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        Broker broker = this.getBrokerFactory().newBroker();
        UpdateThread t1 = new UpdateThread(set, broker);
        UpdateThread t2 = new UpdateThread(set, broker);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (t1.error != null) {
            throw t1.error;
        }
        if (t2.error != null) {
            throw t2.error;
        }
        TestClassDBSequenceFactory.assertEquals((int)102, (int)set.size());
    }

    public void testSequenceGenerator() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        for (int i = 0; i < 100; ++i) {
        }
        for (int j = 0; j < 100; ++j) {
        }
    }

    public static void main(String[] args) {
    }

    private Map getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.Sequence", "db-class(TableName=JDO_CLASS_SEQUENCE");
        return props;
    }

    private static class UpdateThread
    extends Thread {
        private Set _set = null;
        private Broker _broker = null;
        public Exception error = null;

        public UpdateThread(Set set, Broker broker) {
            this._set = set;
            this._broker = broker;
        }

        public void run() {
            try {
                ClassMapping mapping = ((JDBCConfiguration)this._broker.getConfiguration()).getMappingRepositoryInstance().getMapping(SeqD.class, null, true);
                ClassTableJDBCSeq seq = (ClassTableJDBCSeq)this._broker.getIdentitySequence((ClassMetaData)mapping);
                for (int i = 0; i < 51; ++i) {
                    this._set.add(seq.next((StoreContext)this._broker, (ClassMetaData)mapping));
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }
}

