/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.Part;
import org.apache.openjpa.persistence.jdbc.query.cache.PartComposite;

@Entity
@DataCache(timeout=100000)
@Table(name="Usage1")
public class Usage {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    int id;
    int quantity;
    @ManyToOne
    Part child;
    @ManyToOne
    PartComposite parent;
    @Version
    long version;

    public Usage(PartComposite p, int quantity, Part subpart) {
        this.parent = p;
        this.quantity = quantity;
        this.parent.getPartsUsed().add(this);
        this.setChild(subpart);
        subpart.getUsedIn().add(this);
    }

    public Usage() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Part getParent() {
        return this.parent;
    }

    public void setParent(PartComposite parent) {
        this.parent = parent;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public Part getChild() {
        return this.child;
    }

    public void setChild(Part child) {
        this.child = child;
    }

    public String toString() {
        return "Usage:" + this.id + " quantity:" + this.quantity + " child:" + this.child.getPartno() + " parent" + this.parent.getPartno();
    }
}

