/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.jdbc.query.cache.AbstractQueryCacheTest;

public class TestQueryTimestampEviction
extends AbstractQueryCacheTest {
    public void setUp() throws Exception {
        super.setUp("openjpa.DataCache", "true", "openjpa.QueryCache", "true(CacheSize=1000, EvictPolicy='timestamp')", "openjpa.RemoteCommitProvider", "sjvm");
    }

    public void testTimestampEvictionEnablement() {
        ConcurrentQueryCache qc = this.getQueryCache();
        AbstractQueryCache.EvictPolicy ep = qc.getEvictPolicy();
        TestQueryTimestampEviction.assertTrue((ep == AbstractQueryCache.EvictPolicy.TIMESTAMP ? 1 : 0) != 0);
    }

    public void testLoadQueries() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.loadQueryCache();
        int cacheSizeBeforeUpdate = this.queryCacheGet();
        this.updateAnEntity();
        int cacheSizeAfterUpdate = this.queryCacheGet();
        TestQueryTimestampEviction.assertEquals((int)cacheSizeBeforeUpdate, (int)cacheSizeAfterUpdate);
        this.recreateData = false;
    }

    public void testWriteLock() throws Exception {
        final QueryCache qc = this.emf.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        Thread t2 = new Thread(){

            public void run() {
                qc.writeLock();
                qc.writeUnlock();
            }
        };
        t2.start();
        t2.join(5000L);
        if (t2.getState().equals((Object)Thread.State.WAITING)) {
            TestQueryTimestampEviction.fail((String)"The thread is still waiting on a writeLock()!");
        }
    }
}

