/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.cache.Department;
import org.apache.openjpa.persistence.jdbc.query.cache.Employee;
import org.apache.openjpa.persistence.jdbc.query.cache.FullTimeEmployee;
import org.apache.openjpa.persistence.jdbc.query.cache.Invoice;
import org.apache.openjpa.persistence.jdbc.query.cache.InvoiceKey;
import org.apache.openjpa.persistence.jdbc.query.cache.LineItem;
import org.apache.openjpa.persistence.jdbc.query.cache.PartTimeEmployee;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNonPrimaryKeyQueryParameters
extends SQLListenerTestCase {
    private static final int FULLTIME_EMPLOYEE_COUNT = 3;
    private static final int PARTTIME_EMPLOYEE_COUNT = 2;
    private static final int LINEITEM_PER_INVOICE = 1;
    private static final String DEPT_NAME = "ENGINEERING";

    public void setUp() {
        super.setUp(CLEAR_TABLES, Department.class, Employee.class, FullTimeEmployee.class, PartTimeEmployee.class, Invoice.class, LineItem.class, "openjpa.jdbc.QuerySQLCache", "true");
        this.createDepartment(DEPT_NAME);
        this.createInvoice();
        this.sql.clear();
    }

    public void testSelectQueryWithPrimaryKeyParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT d from Department d where d.name=?1");
        query.setParameter(1, (Object)DEPT_NAME);
        Department dept = (Department)query.getSingleResult();
        TestNonPrimaryKeyQueryParameters.assertEquals((int)3, (int)dept.getFullTimeEmployees().size());
        TestNonPrimaryKeyQueryParameters.assertEquals((int)2, (int)dept.getPartTimeEmployees().size());
        this.assertSQL(".* AND t0.TYPE = .*");
        em.close();
    }

    public void testSelectQueryWithNoParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT d from Department d");
        Department dept = (Department)query.getSingleResult();
        TestNonPrimaryKeyQueryParameters.assertEquals((int)3, (int)dept.getFullTimeEmployees().size());
        TestNonPrimaryKeyQueryParameters.assertEquals((int)2, (int)dept.getPartTimeEmployees().size());
        this.assertSQL(".* AND t0.TYPE = .*");
        em.close();
    }

    public void testFind() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Department dept = (Department)em.find(Department.class, (Object)DEPT_NAME);
        TestNonPrimaryKeyQueryParameters.assertEquals((int)3, (int)dept.getFullTimeEmployees().size());
        TestNonPrimaryKeyQueryParameters.assertEquals((int)2, (int)dept.getPartTimeEmployees().size());
        this.assertSQL(".* AND t0.TYPE = .*");
        Invoice invoice = (Invoice)em.find(Invoice.class, (Object)new InvoiceKey(1, "Red"));
        List<LineItem> list = invoice.getLineItems();
        TestNonPrimaryKeyQueryParameters.assertEquals((int)1, (int)list.size());
        em.close();
    }

    public void testSelectSubClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT e from FullTimeEmployee e");
        TestNonPrimaryKeyQueryParameters.assertEquals((int)3, (int)query.getResultList().size());
        query = em.createQuery("SELECT e from PartTimeEmployee e");
        TestNonPrimaryKeyQueryParameters.assertEquals((int)2, (int)query.getResultList().size());
        this.assertSQL(".* WHERE t0.TYPE = .*");
    }

    public void testSelectBaseClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT e from Employee e");
        TestNonPrimaryKeyQueryParameters.assertEquals((int)5, (int)query.getResultList().size());
        this.assertNotSQL(".* WHERE t0.TYPE = .*");
    }

    private void createDepartment(String deptName) {
        Employee e;
        int i;
        if (this.count(Department.class) > 0) {
            return;
        }
        Department dept = new Department();
        dept.setName(deptName);
        for (i = 1; i <= 3; ++i) {
            e = new FullTimeEmployee();
            e.setSsn("888-PP-001" + i);
            ((FullTimeEmployee)e).setSalary(100000.0);
            dept.addEmployee((FullTimeEmployee)e);
        }
        for (i = 1; i <= 2; ++i) {
            e = new PartTimeEmployee();
            e.setSsn("999-PP-001" + i);
            ((PartTimeEmployee)e).setHourlyWage(20.0);
            dept.addEmployee((PartTimeEmployee)e);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)dept);
        em.getTransaction().commit();
        em.close();
    }

    private void createInvoice() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Invoice invoice = new Invoice(1, "Red", 1.3);
        for (int i = 1; i <= 1; ++i) {
            LineItem item = new LineItem(String.valueOf(i), 10);
            item.setInvoice(invoice);
            invoice.getLineItems().add(item);
            em.persist((Object)invoice);
        }
        em.flush();
        tran.commit();
        em.close();
    }
}

