/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Version;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.PartBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DataCache
public class Supplier {
    @Id
    int sid;
    @Column(length=20)
    String name;
    @ManyToMany
    List<PartBase> supplies = new ArrayList<PartBase>();
    @Version
    long version;

    public Supplier() {
    }

    public Supplier(int sid, String name) {
        this.sid = sid;
        this.name = name;
    }

    public Supplier addPart(PartBase p) {
        this.supplies.add(p);
        p.getSuppliers().add(this);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public Collection<PartBase> getSupplies() {
        return this.supplies;
    }

    public void setSupplies(List<PartBase> supplies) {
        this.supplies = supplies;
    }

    public String toString() {
        return "Supplier:" + this.sid + " name:+" + this.name;
    }
}

