/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.Part;
import org.apache.openjpa.persistence.jdbc.query.cache.Usage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DataCache
public class PartComposite
extends Part {
    double assemblyCost;
    double assemblyTime;
    double massIncrement;
    @OneToMany(mappedBy="parent")
    Collection<Usage> partsUsed = new ArrayList<Usage>();

    public PartComposite() {
    }

    public PartComposite(int partno, String name, double asmCost, double massInc) {
        this.partno = partno;
        this.name = name;
        this.assemblyCost = asmCost;
        this.massIncrement = massInc;
        this.inventory = 0;
    }

    public PartComposite addSubPart(EntityManager em, int quantity, Part subpart) {
        Usage use = new Usage(this, quantity, subpart);
        em.persist((Object)use);
        return this;
    }

    public double getAssemblyCost() {
        return this.assemblyCost;
    }

    public void setAssemblyCost(double assemblyCost) {
        this.assemblyCost = assemblyCost;
    }

    public double getMassIncrement() {
        return this.massIncrement;
    }

    public void setMassIncrement(double massIncrement) {
        this.massIncrement = massIncrement;
    }

    public String toString() {
        return "PartComposite:" + this.partno + " name:+" + this.name + " assemblyCost:" + this.assemblyCost + " massIncrement:" + this.massIncrement;
    }

    public Collection<Usage> getPartsUsed() {
        return this.partsUsed;
    }

    public void setPartsUsed(Collection<Usage> partsUsed) {
        this.partsUsed = partsUsed;
    }

    public double getAssemblyTime() {
        return this.assemblyTime;
    }

    public void setAssemblyTime(double assemblyTime) {
        this.assemblyTime = assemblyTime;
    }
}

