/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.Part;
import org.apache.openjpa.persistence.jdbc.query.cache.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DataCache
public class PartBase
extends Part {
    double cost;
    double mass;
    int backOrder;
    @ManyToMany(mappedBy="supplies")
    protected List<Supplier> suppliers = new ArrayList<Supplier>();

    public PartBase() {
    }

    public PartBase(int partno, String name, double cost, double mass) {
        this.partno = partno;
        this.name = name;
        this.cost = cost;
        this.mass = mass;
        this.backOrder = 0;
        this.inventory = 0;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public Collection<Supplier> getSuppliers() {
        return this.suppliers;
    }

    public void setSuppliers(List<Supplier> suppliers) {
        this.suppliers = suppliers;
    }

    public String toString() {
        String sup = "";
        if (this.getSuppliers() != null) {
            for (Supplier s : this.getSuppliers()) {
                sup = sup + s.sid + ",";
            }
        }
        return "PartBase:" + this.partno + " name:+" + this.name + " cost:" + this.cost + " mass:" + this.mass + " supplies=[" + sup + "]";
    }

    public int getBackOrder() {
        return this.backOrder;
    }

    public void setBackOrder(int backOrder) {
        this.backOrder = backOrder;
    }
}

