/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.QueryResultCacheImpl;
import org.apache.openjpa.persistence.jdbc.query.cache.Part;
import org.apache.openjpa.persistence.jdbc.query.cache.PartBase;
import org.apache.openjpa.persistence.jdbc.query.cache.PartComposite;
import org.apache.openjpa.persistence.jdbc.query.cache.Supplier;
import org.apache.openjpa.persistence.jdbc.query.cache.Usage;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.CacheMap;

public abstract class AbstractQueryCacheTest
extends SingleEMFTestCase {
    private Class[] entityClassTypes = new Class[]{Part.class, PartBase.class, PartComposite.class, Supplier.class, Usage.class};
    protected boolean deleteData = false;
    protected boolean recreateData = true;

    public void setUp(Object ... props) {
        int arrLen = this.entityClassTypes.length + props.length;
        Object[] args = new Object[arrLen];
        int idx = 0;
        for (Class clazz : this.entityClassTypes) {
            args[idx++] = clazz;
        }
        for (Object obj : props) {
            args[idx++] = obj;
        }
        super.setUp(args);
        if (this.checkSupportsIdentityGenerationType() && this.recreateData) {
            this.deleteAllData();
            this.reCreateData();
        }
    }

    public void tearDown() throws Exception {
        if (this.deleteData) {
            this.deleteAllData();
        }
    }

    protected void reCreateData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Supplier s1 = new Supplier(1, "S1");
        em.persist((Object)s1);
        Supplier s2 = new Supplier(2, "S2");
        em.persist((Object)s2);
        Supplier s3 = new Supplier(3, "S3");
        em.persist((Object)s3);
        PartBase p1 = new PartBase(10, "Wheel", 150.0, 15.0);
        em.persist((Object)p1);
        PartBase p2 = new PartBase(11, "Frame", 550.0, 25.0);
        em.persist((Object)p2);
        PartBase p3 = new PartBase(12, "HandleBar", 125.0, 80.0);
        em.persist((Object)p3);
        s1.addPart(p1).addPart(p2).addPart(p3);
        s2.addPart(p1).addPart(p3);
        PartComposite p4 = new PartComposite(20, "Bike", 180.0, 1.0);
        em.persist((Object)p4);
        p4.addSubPart((EntityManager)em, 2, p1).addSubPart((EntityManager)em, 1, p2).addSubPart((EntityManager)em, 1, p3);
        em.getTransaction().commit();
        em.close();
    }

    protected void deleteAllData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("delete from Supplier_Part").executeUpdate();
        em.createQuery("delete from PartBase s").executeUpdate();
        em.createQuery("delete from Supplier s").executeUpdate();
        em.createQuery("delete from Usage u").executeUpdate();
        em.createQuery("delete from Part p").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    protected void loadQueryCache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String qry = "select p from PartBase p where p.cost > ?1";
        for (int i = 120; i < 155; ++i) {
            Query q = em.createQuery(qry);
            q.setParameter(1, (Object)new Double(i));
            q.getResultList();
        }
        em.getTransaction().commit();
        em.close();
    }

    protected void updateAnEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PartBase p = (PartBase)em.find(PartBase.class, (Object)11);
        double oldcost = p.getCost();
        if (p != null) {
            p.setCost(oldcost + 10.0);
        }
        em.getTransaction().commit();
        em.close();
    }

    protected ConcurrentQueryCache getQueryCache() {
        OpenJPAEntityManagerFactory oemf = OpenJPAPersistence.cast((EntityManagerFactory)this.emf);
        QueryResultCacheImpl scache = (QueryResultCacheImpl)oemf.getQueryResultCache();
        return (ConcurrentQueryCache)scache.getDelegate();
    }

    protected int queryCacheGet() {
        ConcurrentQueryCache dcache = this.getQueryCache();
        CacheMap map = dcache.getCacheMap();
        return map.size();
    }

    protected boolean checkSupportsIdentityGenerationType() {
        return ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign;
    }

    public void testEviction() {
        if (!this.checkSupportsIdentityGenerationType()) {
            return;
        }
        this.loadQueryCache();
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.updateAnEntity();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String insert1 = "insert into Part(partno,parttype,name,cost,mass) values(13,'PartBase','breakes',1000.0,100.0)";
        em.createNativeQuery(insert1).executeUpdate();
        String insert2 = "insert into Supplier_Part(suppliers_sid,supplies_partno) values(1,13)";
        em.createNativeQuery(insert2).executeUpdate();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String sql = "select partno from Part where cost > 120 ";
        Query nativeq = em.createNativeQuery(sql);
        int nativelistSize = nativeq.getResultList().size();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query q = em.createQuery("select p from PartBase p where p.cost>?1");
        q.setParameter(1, (Object)new Double(120.0));
        int jpalistSize = q.getResultList().size();
        em.getTransaction().commit();
        em.close();
        AbstractQueryCacheTest.assertEquals((int)nativelistSize, (int)jpalistSize);
        this.deleteData = true;
        this.recreateData = true;
    }
}

