/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Applicant;
import org.apache.openjpa.persistence.jdbc.query.domain.Application;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestUpdateSingleValuedAssociation
extends SingleEMFTestCase {
    private static boolean MUST_BE_NULL = true;

    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Application.class, Applicant.class);
    }

    public void testUpdateSingleValuedAssociationToNullViaParameter() {
        this.createApplicationWithNonNullApplicant();
        this.assertUserNullity(!MUST_BE_NULL);
        String jpql = "UPDATE Application a SET a.user = :user";
        this.updateByQuery(jpql, "user", null);
        this.assertUserNullity(MUST_BE_NULL);
    }

    public void testUpdateSingleValuedAssociationToNullViaLiteral() {
        this.createApplicationWithNonNullApplicant();
        this.assertUserNullity(!MUST_BE_NULL);
        String jpql = "UPDATE Application a SET a.user = NULL";
        this.updateByQuery(jpql, new Object[0]);
        this.assertUserNullity(MUST_BE_NULL);
    }

    public void testUpdateSingleValuedAssociationToNonNullViaParameter() {
        Application pc = this.createApplicationWithNullApplicant();
        TestUpdateSingleValuedAssociation.assertNull((Object)pc.getUser());
        String jpql = "UPDATE Application a SET a.user = :user";
        Applicant newUser = this.createApplicant();
        this.updateByQuery(jpql, "user", newUser);
        this.assertUserNullity(!MUST_BE_NULL);
    }

    void assertUserNullity(boolean shouldBeNull) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List result = em.createQuery("SELECT a FROM Application a").getResultList();
        TestUpdateSingleValuedAssociation.assertFalse((boolean)result.isEmpty());
        for (Application pc : result) {
            Applicant user = pc.getUser();
            if (shouldBeNull) {
                TestUpdateSingleValuedAssociation.assertNull((Object)user);
                continue;
            }
            TestUpdateSingleValuedAssociation.assertNotNull((Object)user);
        }
        em.getTransaction().rollback();
    }

    Application createApplicationWithNonNullApplicant() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Application app = new Application();
        Applicant user = new Applicant();
        user.setName("Non-Null User");
        app.setUser(user);
        em.persist((Object)app);
        em.persist((Object)user);
        em.getTransaction().commit();
        return app;
    }

    Application createApplicationWithNullApplicant() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Application app = new Application();
        em.persist((Object)app);
        em.getTransaction().commit();
        return app;
    }

    Applicant createApplicant() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Applicant user = new Applicant();
        user.setName("Non-Null User");
        em.persist((Object)user);
        em.getTransaction().commit();
        return user;
    }

    public void updateByQuery(String jpql, Object ... params) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery(jpql);
        int i = 0;
        while (params != null && i < params.length) {
            query.setParameter(params[i].toString(), params[i + 1]);
            i = 2;
        }
        query.executeUpdate();
        em.getTransaction().commit();
    }
}

