/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.Collection;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.QueryTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestStringFunctions
extends BaseJDBCTest {
    private OpenJPAEntityManager _pm = null;
    private QueryTest1 _match = null;

    public TestStringFunctions(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(QueryTest1.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getTransaction().begin();
        QueryTest1 match = new QueryTest1();
        match.setString("foobarbiz");
        pm.persist((Object)match);
        QueryTest1 fail = new QueryTest1();
        fail.setString("barbizraz");
        pm.persist((Object)fail);
        pm.getTransaction().commit();
        Object oid = pm.getObjectId((Object)match);
        pm.close();
        this._pm = this.currentEntityManager();
        this._match = (QueryTest1)this._pm.getObjectId(oid);
    }

    public void tearDown() throws Exception {
        if (this._pm != null) {
            this._pm.close();
        }
        super.tearDown();
    }

    public void testSubstring() {
        this.assertMatch("string.substring (3) == 'barbiz'");
        this.assertMatch("string.substring (3, 6) == 'bar'");
    }

    public void testIndexOf() {
        this.assertMatch("string.indexOf ('bar') == 3");
        this.assertMatch("string.indexOf (\"b\", 4) == 6");
        this.assertMatch("string.indexOf ('b', 4) == 6");
    }

    public void testToLowerCase() {
        this.assertMatch("string.toLowerCase () == 'foobarbiz'");
        this.assertMatch("'FOOBARBIZ'.toLowerCase () == string");
    }

    public void testToUpperCase() {
        this.assertMatch("string.toUpperCase () == 'FOOBARBIZ'");
    }

    public void testStartsWith() {
        this.assertMatch("string.startsWith ('foobar')");
        this.assertMatch("'foobarbizbaz'.startsWith (string)");
    }

    public void testEndsWith() {
        this.assertMatch("string.endsWith ('barbiz')");
        this.assertMatch("'bazfoobarbiz'.endsWith (string)");
    }

    public void testMatches() {
        this.assertMatch("string.matches ('.oobar.*')");
        this.assertMatch("string.matches ('FOO.AR.IZ(?i)')");
    }

    private void assertMatch(String filter) {
        OpenJPAQuery q = this._pm.createNativeQuery(filter, QueryTest1.class);
        Collection res = q.getCandidateCollection();
        TestStringFunctions.assertEquals((int)1, (int)res.size());
        TestStringFunctions.assertEquals((Object)this._match, res.iterator().next());
        q.closeAll();
    }
}

