/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNativeQueryParameterBinding
extends SingleEMFTestCase {
    private static Class<? extends Exception> NO_ERROR = null;

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES);
    }

    public void testNamedParameterInNativeQueryIsNotValid() {
        String sql = "SELECT * FROM Application WHERE id=:id";
        this.verifyParams(sql, IllegalArgumentException.class, "id", 10);
    }

    public void testPositionalParameterInNativeQueryIsValid() {
        String sql = "SELECT * FROM Application WHERE id=?1";
        this.verifyParams(sql, NO_ERROR, 1, 10);
    }

    public void testZeroPositionalParameterInNativeQueryIsNotValid() {
        String sql = "SELECT * FROM Application WHERE id=?1";
        this.verifyParams(sql, IllegalArgumentException.class, 0, 10);
    }

    public void testNativeQueryDeclaredParameters() {
        String sql = "SELECT * FROM Application WHERE id=?1 AND name=?2";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createNativeQuery(sql);
        TestNativeQueryParameterBinding.assertTrue((boolean)query.getParameters().isEmpty());
    }

    void verifyParams(String jpql, Class<? extends Exception> error, Object ... params) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createNativeQuery(jpql);
        int i = 0;
        while (params != null && i < params.length) {
            block6: {
                try {
                    if (params[i] instanceof Number) {
                        query.setParameter(((Number)params[i]).intValue(), params[i + 1]);
                    } else {
                        query.setParameter(params[i].toString(), params[i + 1]);
                    }
                    if (error != null) {
                        TestNativeQueryParameterBinding.fail((String)("Expected " + error.getName()));
                    }
                }
                catch (Exception e) {
                    if (error.isAssignableFrom(e.getClass())) break block6;
                    throw new RuntimeException("An unexpected exception occurred see the initCause for details", e);
                }
            }
            i = 2;
        }
        em.getTransaction().commit();
    }
}

