/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Magazine;
import org.apache.openjpa.persistence.jdbc.query.domain.Publisher;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleEntityProjection
extends SingleEMFTestCase {
    private static boolean INNER_JOIN = true;
    private static String[][] MAGAZINE_PUBLISHER_NAME_PAIRS = new String[][]{{"Times", "Publisher-0"}, {"Times Life", "Publisher-1"}, {"Times Kid", null}, {"Newsweek", "Publisher-3"}, {"People", null}, {"Nature", "Publisher-5"}, {"MIT Review", "Publisher-6"}, {"Wired", "Publisher-7"}};

    public void setUp() {
        super.setUp(CLEAR_TABLES, Magazine.class, Publisher.class);
        this.createData();
    }

    void createData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < MAGAZINE_PUBLISHER_NAME_PAIRS.length; ++i) {
            String magName = MAGAZINE_PUBLISHER_NAME_PAIRS[i][0];
            String pubName = MAGAZINE_PUBLISHER_NAME_PAIRS[i][1];
            Magazine mag = new Magazine();
            mag.setName(magName);
            if (pubName != null) {
                Publisher pub = new Publisher();
                pub.setName(pubName);
                mag.setPublisher(pub);
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = df.parse("2001-01-01");
                    mag.setDatePublished(date);
                }
                catch (ParseException e) {
                    mag.setDatePublished(null);
                }
                mag.setTsPublished(new Timestamp(System.currentTimeMillis() - 100000L));
                em.persist((Object)pub);
            }
            em.persist((Object)mag);
        }
        em.getTransaction().commit();
    }

    public void testMultipleEntitiesInProjectionUsingOuterJoin() {
        String jpql = "select m, p from Magazine m left outer join m.publisher p where ((:useName = false) or (m.name like :name))";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery(jpql);
        String magKey = "Times";
        query.setParameter("useName", (Object)true);
        query.setParameter("name", (Object)('%' + magKey + '%'));
        List result = query.getResultList();
        int expecetedCount = this.getExpecetedResultCount(magKey, !INNER_JOIN);
        TestMultipleEntityProjection.assertFalse((boolean)result.isEmpty());
        TestMultipleEntityProjection.assertEquals((int)expecetedCount, (int)result.size());
        for (Object o : result) {
            TestMultipleEntityProjection.assertTrue((boolean)(o instanceof Object[]));
            Object[] row = (Object[])o;
            TestMultipleEntityProjection.assertEquals((int)2, (int)row.length);
            TestMultipleEntityProjection.assertTrue((boolean)(row[0] instanceof Magazine));
            TestMultipleEntityProjection.assertTrue((row[1] == null || row[1] instanceof Publisher ? 1 : 0) != 0);
            TestMultipleEntityProjection.assertNotNull((Object)row[0]);
            TestMultipleEntityProjection.assertEquals((Object)((Magazine)row[0]).getPublisher(), (Object)row[1]);
        }
    }

    public void testMultipleEntitiesInProjectionUsingInnerJoin() {
        String jpql = "select m, p from Magazine m inner join m.publisher p where ((:useName = false) or (m.name like :name))";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery(jpql);
        String magKey = "Times";
        query.setParameter("useName", (Object)true);
        query.setParameter("name", (Object)('%' + magKey + '%'));
        List result = query.getResultList();
        int expecetedCount = this.getExpecetedResultCount(magKey, INNER_JOIN);
        TestMultipleEntityProjection.assertFalse((boolean)result.isEmpty());
        TestMultipleEntityProjection.assertEquals((int)expecetedCount, (int)result.size());
        for (Object o : result) {
            TestMultipleEntityProjection.assertTrue((boolean)(o instanceof Object[]));
            Object[] row = (Object[])o;
            TestMultipleEntityProjection.assertEquals((int)2, (int)row.length);
            TestMultipleEntityProjection.assertTrue((boolean)(row[0] instanceof Magazine));
            TestMultipleEntityProjection.assertTrue((boolean)(row[1] instanceof Publisher));
            TestMultipleEntityProjection.assertNotNull((Object)row[0]);
            TestMultipleEntityProjection.assertNotNull((Object)row[1]);
            TestMultipleEntityProjection.assertEquals((Object)((Magazine)row[0]).getPublisher(), (Object)row[1]);
        }
    }

    public void testAggregateExpressionInHavingExpression() {
        String jpql = "select m.publisher, max(m.datePublished) from Magazine m group by m.publisher having max(m.datePublished) is null";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery(jpql);
        List result = query.getResultList();
        TestMultipleEntityProjection.assertTrue((boolean)result.isEmpty());
        jpql = "select m.publisher, max(m.datePublished) from Magazine m group by m.publisher having max(m.tsPublished) = CURRENT_TIMESTAMP";
        query = em.createQuery(jpql);
        result = query.getResultList();
        TestMultipleEntityProjection.assertTrue((boolean)result.isEmpty());
    }

    private int getExpecetedResultCount(String key, boolean innerJoin) {
        int count = 0;
        for (int i = 0; i < MAGAZINE_PUBLISHER_NAME_PAIRS.length; ++i) {
            String magName = MAGAZINE_PUBLISHER_NAME_PAIRS[i][0];
            String pubName = MAGAZINE_PUBLISHER_NAME_PAIRS[i][1];
            if (magName.indexOf(key) == -1 || innerJoin && (!innerJoin || pubName == null)) continue;
            ++count;
        }
        return count;
    }
}

