/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Chess;
import org.apache.openjpa.persistence.jdbc.query.domain.Game;
import org.apache.openjpa.persistence.jdbc.query.domain.IndoorGame;
import org.apache.openjpa.persistence.jdbc.query.domain.Scrabble;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestGroupByQuery
extends SingleEMFTestCase {
    public void setUp() {
        super.setUp(DROP_TABLES, Game.class, IndoorGame.class, Scrabble.class, Chess.class);
        try {
            this.createData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void createData() throws Exception {
        Class[] classes;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Class cls : classes = new Class[]{Game.class, IndoorGame.class, Scrabble.class, Chess.class}) {
            for (int i = 1; i <= 4; ++i) {
                Game p = (Game)cls.newInstance();
                p.setName(cls.getSimpleName() + "-" + i);
                em.persist((Object)p);
            }
        }
        em.getTransaction().commit();
    }

    public void testGroupBy() {
        String jpql = "SELECT g.name, g.nTile FROM Scrabble g WHERE (g.name = ANY(SELECT g1.name FROM Scrabble g1 GROUP BY g1.name )) ORDER BY g.name";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List employees = em.createQuery(jpql).getResultList();
    }
}

