/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.order;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import org.apache.openjpa.persistence.jdbc.order.Game;
import org.apache.openjpa.persistence.jdbc.order.Person;
import org.apache.openjpa.persistence.jdbc.order.Trainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Player
extends Person {
    private int playerNumber;
    @ManyToMany(mappedBy="playersTrained")
    private List<Trainer> trainers;
    @ManyToMany(mappedBy="playedIn")
    @OrderColumn(name="playedInOrder")
    private List<Game> gamesPlayedIn;

    public Player() {
    }

    public Player(String name, int number) {
        this.setName(name);
        this.playerNumber = number;
    }

    public void setPlayerNumber(int number) {
        this.playerNumber = number;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public void setTrainers(List<Trainer> trainers) {
        this.trainers = trainers;
    }

    public List<Trainer> getTrainers() {
        return this.trainers;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Player) {
            Player player = (Player)obj;
            return super.equals(obj) && player.getPlayerNumber() == this.playerNumber;
        }
        return false;
    }

    public void setGamesPlayedIn(List<Game> gamesPlayedIn) {
        this.gamesPlayedIn = gamesPlayedIn;
    }

    public List<Game> getGamesPlayedIn() {
        return this.gamesPlayedIn;
    }
}

