/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.order;

import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.openjpa.persistence.jdbc.order.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="OCCourse")
public class Course {
    private int id;
    private String name;
    private Set<Student> students;
    private List<Student> waitList;

    public Course() {
    }

    public Course(String name) {
        this.name = name;
    }

    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="COURSE_ENROLLMENT")
    public Set<Student> getStudents() {
        return this.students;
    }

    public void setStudents(Set<Student> students) {
        this.students = students;
    }

    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="WAIT_LIST")
    @OrderColumn(name="WAITLIST_ORDER")
    public List<Student> getWaitList() {
        return this.waitList;
    }

    public void setWaitList(List<Student> list) {
        this.waitList = list;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Course) {
            Course course = (Course)obj;
            return this.getId() == course.getId() && this.getName().equalsIgnoreCase(course.getName());
        }
        return false;
    }
}

