/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.vertical;

import java.util.Iterator;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.Base;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub2;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub2;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestSubclassJoinExtent
extends TestSQLListenerTestCase {
    private String _outer = "OUTER";

    public TestSubclassJoinExtent(String name) {
        super(name);
    }

    public boolean skipTest() {
        return false;
    }

    public void setUpTestCase() {
        Class[] reg = new Class[]{Base.class, BaseSub1.class, BaseSub2.class, BaseSub1Sub1.class, BaseSub1Sub2.class};
        if (((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance().joinSyntax == 2) {
            this._outer = "(+)";
        }
        this.deleteAll(Base.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        Base base = new Base();
        base.setBaseField(1);
        pm.persist((Object)base);
        BaseSub1 sub1 = new BaseSub1();
        sub1.setBaseField(2);
        sub1.setBaseSub1Field(3);
        pm.persist((Object)sub1);
        BaseSub2 sub2 = new BaseSub2();
        sub2.setBaseField(3);
        sub2.setBaseSub2Field(4);
        pm.persist((Object)sub2);
        BaseSub1Sub2 sub1sub2 = new BaseSub1Sub2();
        sub1sub2.setBaseField(4);
        sub1sub2.setBaseSub1Field(5);
        sub1sub2.setBaseSub1Sub2Field(6);
        pm.persist((Object)sub1sub2);
        this.endTx((EntityManager)pm);
        pm.close();
    }

    public void testBaseNoSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(Base.class, false);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        Base pc = (Base)itr.next();
        TestSubclassJoinExtent.assertEquals((int)1, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals(Base.class, pc.getClass());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testBaseWithSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(Base.class, true);
        TreeSet pcs = new TreeSet(extent.list());
        TestSubclassJoinExtent.assertEquals((int)4, (int)pcs.size());
        Iterator itr = pcs.iterator();
        block6: for (int i = 0; i < 4; ++i) {
            Base pc = (Base)itr.next();
            TestSubclassJoinExtent.assertEquals((int)(i + 1), (int)pc.getBaseField());
            switch (i) {
                case 0: {
                    TestSubclassJoinExtent.assertEquals(Base.class, pc.getClass());
                    continue block6;
                }
                case 1: {
                    TestSubclassJoinExtent.assertEquals(BaseSub1.class, pc.getClass());
                    continue block6;
                }
                case 2: {
                    TestSubclassJoinExtent.assertEquals(BaseSub2.class, pc.getClass());
                    continue block6;
                }
                case 3: {
                    TestSubclassJoinExtent.assertEquals(BaseSub1Sub2.class, pc.getClass());
                }
            }
        }
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEmptyNoSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1Sub1.class, false);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        this.assertNotSQL(this._outer);
    }

    public void testEmptyWithSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1Sub1.class, true);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        this.assertNotSQL(this._outer);
    }

    public void testLeafNoSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1Sub2.class, false);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        BaseSub1Sub2 pc = (BaseSub1Sub2)itr.next();
        TestSubclassJoinExtent.assertEquals((int)4, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)5, (int)pc.getBaseSub1Field());
        TestSubclassJoinExtent.assertEquals((int)6, (int)pc.getBaseSub1Sub2Field());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testLeafWithSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1Sub2.class, true);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        BaseSub1Sub2 pc = (BaseSub1Sub2)itr.next();
        TestSubclassJoinExtent.assertEquals((int)4, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)5, (int)pc.getBaseSub1Field());
        TestSubclassJoinExtent.assertEquals((int)6, (int)pc.getBaseSub1Sub2Field());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testLeafNoSubs2() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub2.class, false);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        BaseSub2 pc = (BaseSub2)itr.next();
        TestSubclassJoinExtent.assertEquals((int)3, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)4, (int)pc.getBaseSub2Field());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testLeafWithSubs2() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub2.class, true);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        BaseSub2 pc = (BaseSub2)itr.next();
        TestSubclassJoinExtent.assertEquals((int)3, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)4, (int)pc.getBaseSub2Field());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testMidNoSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1.class, false);
        Iterator itr = extent.iterator();
        TestSubclassJoinExtent.assertTrue((boolean)itr.hasNext());
        BaseSub1 pc = (BaseSub1)itr.next();
        TestSubclassJoinExtent.assertEquals((int)2, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)3, (int)pc.getBaseSub1Field());
        TestSubclassJoinExtent.assertEquals(BaseSub1.class, pc.getClass());
        TestSubclassJoinExtent.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testMidWithSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(BaseSub1.class, true);
        TreeSet pcs = new TreeSet(extent.list());
        TestSubclassJoinExtent.assertEquals((int)2, (int)pcs.size());
        Iterator itr = pcs.iterator();
        BaseSub1 pc = (BaseSub1)itr.next();
        TestSubclassJoinExtent.assertEquals((int)2, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)3, (int)pc.getBaseSub1Field());
        TestSubclassJoinExtent.assertEquals(BaseSub1.class, pc.getClass());
        pc = (BaseSub1)itr.next();
        TestSubclassJoinExtent.assertEquals((int)4, (int)pc.getBaseField());
        TestSubclassJoinExtent.assertEquals((int)5, (int)pc.getBaseSub1Field());
        TestSubclassJoinExtent.assertEquals(BaseSub1Sub2.class, pc.getClass());
        TestSubclassJoinExtent.assertEquals((int)6, (int)((BaseSub1Sub2)pc).getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinExtent.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }
}

