/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.tableperclass;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.jdbc.common.apps.PlaceholderTypesA;
import org.apache.openjpa.persistence.jdbc.common.apps.PlaceholderTypesB;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;
import org.apache.openjpa.util.Id;

public class TestUnionPlaceholderTypes
extends TestSQLListenerTestCase {
    private boolean _union = false;

    public TestUnionPlaceholderTypes(String name) {
        super(name);
    }

    public void setUpTestCase() {
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
    }

    public void testUnion() throws Exception {
        this.deleteAll(PlaceholderTypesA.class);
        PlaceholderTypesA pta = new PlaceholderTypesA();
        pta.setIntA(1);
        PlaceholderTypesB ptb = new PlaceholderTypesB();
        ptb.setIntA(2);
        ptb.setIntB(3);
        ptb.setBooleanB(true);
        ptb.setByteB((byte)64);
        ptb.setCharB('a');
        ptb.setFloatB(99.9f);
        ptb.setStringB("stringB");
        ptb.setClobB("clobB");
        ptb.setBlobB("blobB");
        Broker broker = this.getBrokerFactory().newBroker();
        broker.begin();
        broker.persist((Object)pta, null);
        broker.persist((Object)ptb, null);
        broker.commit();
        Object oida = broker.getObjectId((Object)pta);
        long idb = ((Id)broker.getObjectId((Object)ptb)).getId();
        broker.close();
        broker = this.getBrokerFactory().newBroker();
        broker.begin();
        sql.clear();
        pta = (PlaceholderTypesA)broker.find(oida, true, null);
        TestUnionPlaceholderTypes.assertEquals((int)1, (int)pta.getIntA());
        if (this._union) {
            TestUnionPlaceholderTypes.assertEquals((int)1, (int)sql.size());
        } else {
            this.assertNotSQL("UNION");
        }
        broker.close();
        broker = this.getBrokerFactory().newBroker();
        broker.begin();
        sql.clear();
        ptb = (PlaceholderTypesB)broker.find(broker.newObjectId(PlaceholderTypesB.class, (Object)new Long(idb)), true, null);
        TestUnionPlaceholderTypes.assertEquals((int)2, (int)ptb.getIntA());
        TestUnionPlaceholderTypes.assertEquals((int)3, (int)ptb.getIntB());
        TestUnionPlaceholderTypes.assertTrue((boolean)ptb.getBooleanB());
        TestUnionPlaceholderTypes.assertEquals((int)64, (int)ptb.getByteB());
        TestUnionPlaceholderTypes.assertEquals((char)'a', (char)ptb.getCharB());
        TestUnionPlaceholderTypes.assertEquals((double)99.9f, (double)ptb.getFloatB(), (double)0.001);
        TestUnionPlaceholderTypes.assertEquals((String)"stringB", (String)ptb.getStringB());
        TestUnionPlaceholderTypes.assertEquals((String)"clobB", (String)ptb.getClobB());
        TestUnionPlaceholderTypes.assertEquals((Object)"blobB", (Object)ptb.getBlobB());
        if (this._union) {
            TestUnionPlaceholderTypes.assertEquals((int)1, (int)sql.size());
        } else {
            this.assertNotSQL("UNION");
        }
        broker.close();
    }
}

