/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.StateImagePC2;
import org.apache.openjpa.persistence.jdbc.common.apps.StateImagePC3;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestStateImage
extends TestSQLListenerTestCase {
    private Object _oid = null;

    public TestStateImage() {
    }

    public TestStateImage(String test) {
        super(test);
    }

    public void setUpTestCase() {
        this.deleteAll(StateImagePC2.class);
        this.deleteAll(StateImagePC3.class);
        StateImagePC2 pc = new StateImagePC2();
        pc.setStringField("string1");
        pc.setIntField(1);
        StateImagePC2 pc2 = new StateImagePC2();
        pc2.setStringField("string2");
        pc2.setIntField(2);
        pc.setStateImage(pc2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getTransaction().begin();
        pm.persist((Object)pc);
        this._oid = pm.getObjectId((Object)pc);
        pm.getTransaction().commit();
        pm.close();
    }

    public void testOptLock() {
        OpenJPAEntityManager pm1 = this.getEm(true, true);
        OpenJPAEntityManager pm2 = this.getEm(true, true);
        pm1.getTransaction().begin();
        pm2.getTransaction().begin();
        StateImagePC2 pc1 = (StateImagePC2)pm1.getObjectId(this._oid);
        StateImagePC2 pc2 = (StateImagePC2)pm2.getObjectId(this._oid);
        pc1.setIntField(3);
        pc1.setStateImage(null);
        pc2.setIntField(4);
        pm1.getTransaction().commit();
        try {
            pm2.getTransaction().commit();
            TestStateImage.fail((String)"Should have caused OL exception.");
        }
        catch (Exception jfe) {
            pm2.getTransaction().begin();
            pm2.refresh((Object)pc2);
            pc2.setIntField(4);
            pm2.getTransaction().commit();
        }
        pm2.getTransaction().begin();
        pc2.setIntField(5);
        pm2.getTransaction().commit();
        pm1.getTransaction().begin();
        pm1.refresh((Object)pc1);
        pc1.setIntField(6);
        pm2.getTransaction().begin();
        pc2.setIntField(7);
        pm1.getTransaction().commit();
        try {
            pm2.getTransaction().commit();
            TestStateImage.fail((String)"Should have caused OL exception.");
        }
        catch (Exception jfe) {
            pm2.getTransaction().begin();
            pm2.refresh((Object)pc2);
            pc2.setIntField(7);
            pm2.getTransaction().commit();
        }
        pm1.close();
        pm2.close();
        OpenJPAEntityManager pm = this.currentEntityManager();
        StateImagePC2 pc = (StateImagePC2)pm.getObjectId(this._oid);
        TestStateImage.assertNull((Object)pc.getStateImage());
        TestStateImage.assertEquals((int)7, (int)pc.getIntField());
        pm.close();
    }

    public void NOTWORKINGtestOptLockWithDelete() {
        OpenJPAEntityManager pm1 = this.getEm(true, true);
        StateImagePC2 pc1 = (StateImagePC2)pm1.getObjectId(this._oid);
        OpenJPAEntityManager pm2 = this.getEm(true, true);
        StateImagePC2 pc2 = (StateImagePC2)pm2.getObjectId(this._oid);
        pm1.getTransaction().begin();
        pc1.setIntField(3);
        pm2.getTransaction().begin();
        pm2.remove((Object)pc2);
        pm1.getTransaction().commit();
        try {
            pm2.getTransaction().commit();
            TestStateImage.fail((String)"Should have caused OL exception.");
        }
        catch (Exception jfe) {
            pm2.getTransaction().begin();
            pm2.refresh((Object)pc2);
            pm2.remove((Object)pc2);
            pm2.getTransaction().commit();
        }
    }

    public void testOptLockOnVerticalClass() {
        OpenJPAEntityManager pm1 = this.getEm(true, true);
        OpenJPAEntityManager pm2 = this.getEm(true, true);
        OpenJPAQuery q1 = pm1.createNativeQuery("", StateImagePC2.class);
        StateImagePC2 pc1 = (StateImagePC2)q1.getCandidateCollection().iterator().next();
        q1.closeAll();
        OpenJPAQuery q2 = pm2.createNativeQuery("", StateImagePC2.class);
        StateImagePC2 pc2 = (StateImagePC2)q2.getCandidateCollection().iterator().next();
        q2.closeAll();
        pm1.getTransaction().begin();
        pc1.setStringField("changed1");
        pc1.setStateImage(null);
        pm2.getTransaction().begin();
        pc2.setStringField("changed2");
        pm1.getTransaction().commit();
        try {
            pm2.getTransaction().commit();
            TestStateImage.fail((String)"Should have caused OL exception.");
        }
        catch (Exception jfe) {
            pm2.getTransaction().begin();
            pm2.refresh((Object)pc2);
            pc2.setStringField("changed2");
            pm2.getTransaction().commit();
        }
        pm1.close();
        pm2.close();
        OpenJPAEntityManager pm = this.currentEntityManager();
        StateImagePC2 pc = (StateImagePC2)pm.getObjectId(this._oid);
        TestStateImage.assertNull((Object)pc.getStateImage());
        TestStateImage.assertEquals((String)"changed2", (String)pc.getStringField());
        pm.close();
    }

    public void testLockGroup() throws Exception {
        OpenJPAEntityManager pm = this.getEm(true, true);
        pm.getTransaction().begin();
        StateImagePC3 pc = new StateImagePC3();
        pc.setLockField(4);
        pc.setNoLockField(6);
        pm.persist((Object)pc);
        pm.getTransaction().commit();
        pm.getTransaction().begin();
        pc.setLockField(6);
        sql.clear();
        pm.getTransaction().commit();
        this.assertNotSQL("* WHERE * NOLOCK*");
        pm.close();
    }

    public static void main(String[] args) {
    }

    private OpenJPAEntityManager getEm(boolean optimistic, boolean retainValues) {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.setNontransactionalRead(true);
        em.setRetainState(retainValues);
        em.setOptimistic(optimistic);
        return em;
    }
}

