/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.EagerOuterJoinPC;
import org.apache.openjpa.persistence.jdbc.common.apps.EagerOuterJoinPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.HelperPC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestRangeQuery
extends BaseJDBCTest {
    public TestRangeQuery(String name) {
        super(name);
    }

    public boolean skipTest() {
        DBDictionary dict = ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance();
        return !dict.supportsSubselect;
    }

    public void setUp() {
        this.deleteAll(HelperPC.class);
        this.deleteAll(EagerOuterJoinPC2.class);
        this.deleteAll(EagerOuterJoinPC.class);
    }

    public void testQueryRange() {
        this.insertManyStringList();
        OpenJPAEntityManager em = this.currentEntityManager();
        FetchPlan fetch = em.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringList");
        fetch.setFetchBatchSize(3);
        OpenJPAQuery q = em.createQuery("javax.persistence.JPQL", "select x from EagerOuterJoinPC x order by x.name asc");
        q.setFirstResult(5).setMaxResults(15);
        List results = q.getResultList();
        TestRangeQuery.assertEquals((int)5, (int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            EagerOuterJoinPC pc = (EagerOuterJoinPC)results.get(i);
            TestRangeQuery.assertEquals((String)String.valueOf(i + 5), (String)pc.getName());
        }
        q.closeAll();
        em.close();
    }

    private void insertManyStringList() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        for (int i = 0; i < 10; ++i) {
            EagerOuterJoinPC pc = new EagerOuterJoinPC();
            pc.setName(String.valueOf(i));
            pc.getStringList().add(i + ".1");
            pc.getStringList().add(i + ".2");
            em.persist((Object)pc);
        }
        this.endTx((EntityManager)em);
        em.close();
    }
}

