/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.Arrays;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.common.apps.LocatorTestObject;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestLocators
extends BaseJDBCTest {
    private OpenJPAEntityManagerFactory pmf;

    public TestLocators(String name) {
        super(name);
    }

    public TestLocators() {
    }

    public void setUp() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        Extent e = pm.createExtent(LocatorTestObject.class, true);
        Iterator i = e.iterator();
        while (i.hasNext()) {
            pm.remove(i.next());
        }
        this.endTx((EntityManager)pm);
        pm.close();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.deleteAll(LocatorTestObject.class);
    }

    public void testBLOBs() {
        this.doBlobTest(50000);
    }

    public void testSmallBLOBs() {
        this.doBlobTest(50);
        if (this.getCurrentPlatform() == AbstractTestCase.Platform.ORACLE) {
            OpenJPAEntityManager pm = this.currentEntityManager();
            JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerSPI)pm).getConfiguration();
            OracleDictionary dict = (OracleDictionary)conf.getDBDictionaryInstance();
            int t = dict.maxEmbeddedBlobSize;
            this.doBlobTest(t - 1);
            this.doBlobTest(t);
            this.doBlobTest(t + 1);
        }
    }

    public void doBlobTest(int size) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        LocatorTestObject o = new LocatorTestObject();
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)98);
        o.setBytes(bytes);
        pm.persist((Object)o);
        Object oid = pm.getObjectId((Object)o);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        byte[] newbytes = o.getBytes();
        TestLocators.assertNotNull((Object)newbytes);
        TestLocators.assertEquals((int)bytes.length, (int)newbytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            TestLocators.assertEquals((byte)bytes[i], (byte)newbytes[i]);
        }
    }

    public void testShrinkBLOB() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        LocatorTestObject o = new LocatorTestObject();
        byte[] bytes = new byte[50000];
        Arrays.fill(bytes, (byte)98);
        o.setBytes(bytes);
        pm.persist((Object)o);
        Object oid = pm.getObjectId((Object)o);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        this.startTx((EntityManager)pm);
        bytes = new byte[40000];
        Arrays.fill(bytes, (byte)99);
        o.setBytes(bytes);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        byte[] newbytes = o.getBytes();
        TestLocators.assertEquals((int)bytes.length, (int)newbytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            TestLocators.assertEquals((byte)bytes[i], (byte)newbytes[i]);
        }
    }

    public void testCLOBs() {
        this.doClobTest(50000);
    }

    public void testSmallCLOBs() {
        this.doClobTest(50);
        if (this.getCurrentPlatform() == AbstractTestCase.Platform.ORACLE) {
            OpenJPAEntityManager pm = this.currentEntityManager();
            JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerSPI)pm).getConfiguration();
            OracleDictionary dict = (OracleDictionary)conf.getDBDictionaryInstance();
            int t = dict.maxEmbeddedClobSize;
            this.doClobTest(t - 1);
            this.doClobTest(t);
            this.doClobTest(t + 1);
        }
    }

    public void doClobTest(int size) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        LocatorTestObject o = new LocatorTestObject();
        char[] chars = new char[size];
        Arrays.fill(chars, 'c');
        o.setClobString(new String(chars));
        pm.persist((Object)o);
        Object oid = pm.getObjectId((Object)o);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        char[] newchars = o.getClobString().toCharArray();
        TestLocators.assertNotNull((Object)newchars);
        TestLocators.assertEquals((int)chars.length, (int)newchars.length);
        for (int i = 0; i < chars.length; ++i) {
            TestLocators.assertEquals((char)chars[i], (char)newchars[i]);
        }
    }

    public void testShrinkCLOB() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        LocatorTestObject o = new LocatorTestObject();
        char[] chars = new char[50000];
        Arrays.fill(chars, 'c');
        o.setClobString(new String(chars));
        pm.persist((Object)o);
        Object oid = pm.getObjectId((Object)o);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        this.startTx((EntityManager)pm);
        chars = new char[40000];
        Arrays.fill(chars, 'd');
        o.setClobString(new String(chars));
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        o = (LocatorTestObject)pm.getObjectId(oid);
        char[] newchars = o.getClobString().toCharArray();
        TestLocators.assertEquals((int)chars.length, (int)newchars.length);
        for (int i = 0; i < chars.length; ++i) {
            TestLocators.assertEquals((char)chars[i], (char)newchars[i]);
        }
    }
}

