/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.Collection;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.ConstantJoinPC;
import org.apache.openjpa.persistence.jdbc.common.apps.ConstantJoinPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.ConstantJoinPC3;
import org.apache.openjpa.persistence.jdbc.common.apps.NonPKJoinPC;
import org.apache.openjpa.persistence.jdbc.common.apps.NonPKJoinPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.NonPKJoinPC3;
import org.apache.openjpa.persistence.jdbc.common.apps.PartialJoinPC;
import org.apache.openjpa.persistence.jdbc.common.apps.PartialJoinPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.PartialJoinPC3;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestIrregularJoins
extends BaseJDBCTest {
    private Object _nonpk = null;
    private Object _nonpk3 = null;
    private Object _partial = null;
    private Object _partial3 = null;
    private Object _constant2 = null;
    private Object _constant3 = null;

    public TestIrregularJoins(String test) {
        super(test);
    }

    public TestIrregularJoins() {
    }

    public void setUp() throws Exception {
        new ConstantJoinPC();
        new ConstantJoinPC2();
        new ConstantJoinPC3();
        this.deleteAll(PartialJoinPC.class);
        this.deleteAll(NonPKJoinPC.class);
        this.deleteAll(ConstantJoinPC.class);
        PartialJoinPC partial = new PartialJoinPC();
        partial.setPk1(1);
        partial.setPk2(2);
        PartialJoinPC2 partial2 = new PartialJoinPC2();
        partial2.setPk1(2);
        partial2.setPk2(3);
        PartialJoinPC3 partial3 = new PartialJoinPC3();
        partial3.setPk1(3);
        partial3.setPk2(4);
        NonPKJoinPC nonpk = new NonPKJoinPC();
        nonpk.setId1(1);
        nonpk.setId2(2);
        NonPKJoinPC2 nonpk2 = new NonPKJoinPC2();
        nonpk2.setId1(2);
        nonpk2.setId2(3);
        NonPKJoinPC3 nonpk3 = new NonPKJoinPC3();
        nonpk3.setId1(3);
        nonpk3.setId2(4);
        partial.setNonPK(nonpk);
        partial.getNonPKs().add(nonpk);
        nonpk.setPartial(partial);
        nonpk.getPartials().add(partial);
        partial3.setNonPK(nonpk);
        partial3.setNonPK3(nonpk3);
        partial3.getNonPKs().add(nonpk);
        partial3.getNonPK2s().add(nonpk2);
        nonpk3.setPartial(partial);
        nonpk3.setPartial3(partial3);
        nonpk3.getPartials().add(partial);
        nonpk3.getPartial2s().add(partial2);
        ConstantJoinPC2 constant2 = new ConstantJoinPC2();
        constant2.setPk1(1);
        constant2.setPk2(2);
        constant2.setNonPK(nonpk3);
        constant2.setNonPK2(nonpk3);
        nonpk.setConstant(constant2);
        nonpk2.setConstant(constant2);
        nonpk3.setConstant(constant2);
        ConstantJoinPC3 constant3 = new ConstantJoinPC3();
        constant3.setPk1(1);
        constant3.setPk2(3);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)partial);
        pm.persist((Object)partial3);
        pm.persist((Object)constant2);
        pm.persist((Object)constant3);
        this.endTx((EntityManager)pm);
        this._partial = pm.getObjectId((Object)partial);
        this._partial3 = pm.getObjectId((Object)partial3);
        this._nonpk = pm.getObjectId((Object)nonpk);
        this._nonpk3 = pm.getObjectId((Object)nonpk3);
        this._constant2 = pm.getObjectId((Object)constant2);
        this._constant3 = pm.getObjectId((Object)constant3);
        pm.close();
    }

    public void testNonPKOneOne() {
        this.nonPKOneOne(this.currentEntityManager());
    }

    public void testEagerNonPKOneOne() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPK");
        this.nonPKOneOne(pm);
    }

    private void nonPKOneOne(OpenJPAEntityManager pm) {
        PartialJoinPC partial = (PartialJoinPC)pm.getObjectId(this._partial);
        NonPKJoinPC nonpk = partial.getNonPK();
        TestIrregularJoins.assertEquals((int)1, (int)nonpk.getId1());
        TestIrregularJoins.assertEquals((int)2, (int)nonpk.getId2());
        pm.close();
    }

    public void testPartialOneOne() {
        this.partialOneOne(this.currentEntityManager());
    }

    public void testEagerPartialOneOne() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("partial");
        this.partialOneOne(pm);
    }

    private void partialOneOne(OpenJPAEntityManager pm) {
        NonPKJoinPC nonpk = (NonPKJoinPC)pm.getObjectId(this._nonpk);
        PartialJoinPC partial = nonpk.getPartial();
        TestIrregularJoins.assertEquals((int)1, (int)partial.getPk1());
        TestIrregularJoins.assertEquals((int)2, (int)partial.getPk2());
        pm.close();
    }

    public void testVerticalNonPKOneOne() {
        this.verticalNonPKOneOne(this.currentEntityManager());
    }

    public void testEagerVerticalNonPKOneOne() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPK3");
        this.verticalNonPKOneOne(pm);
    }

    private void verticalNonPKOneOne(OpenJPAEntityManager pm) {
        PartialJoinPC3 partial3 = (PartialJoinPC3)pm.getObjectId(this._partial3);
        NonPKJoinPC nonpk = partial3.getNonPK();
        TestIrregularJoins.assertEquals((int)1, (int)nonpk.getId1());
        TestIrregularJoins.assertEquals((int)2, (int)nonpk.getId2());
        NonPKJoinPC3 nonpk3 = partial3.getNonPK3();
        TestIrregularJoins.assertEquals((int)3, (int)nonpk3.getId1());
        TestIrregularJoins.assertEquals((int)4, (int)nonpk3.getId2());
        pm.close();
    }

    public void testVerticalPartialOneOne() {
        this.verticalPartialOneOne(this.currentEntityManager());
    }

    public void testEagerVerticalPartialOneOne() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("partial3");
        this.verticalPartialOneOne(pm);
    }

    private void verticalPartialOneOne(OpenJPAEntityManager pm) {
        NonPKJoinPC3 nonpk3 = (NonPKJoinPC3)pm.getObjectId(this._nonpk3);
        PartialJoinPC partial = nonpk3.getPartial();
        TestIrregularJoins.assertEquals((int)1, (int)partial.getPk1());
        TestIrregularJoins.assertEquals((int)2, (int)partial.getPk2());
        PartialJoinPC3 partial3 = nonpk3.getPartial3();
        TestIrregularJoins.assertEquals((int)3, (int)partial3.getPk1());
        TestIrregularJoins.assertEquals((int)4, (int)partial3.getPk2());
        pm.close();
    }

    public void testNonPKManyMany() {
        this.nonPKManyMany(this.currentEntityManager());
    }

    public void testEagerNonPKManyMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPKs");
        this.nonPKManyMany(pm);
    }

    private void nonPKManyMany(OpenJPAEntityManager pm) {
        PartialJoinPC partial = (PartialJoinPC)pm.getObjectId(this._partial);
        Set nonpks = partial.getNonPKs();
        TestIrregularJoins.assertEquals((int)1, (int)nonpks.size());
        NonPKJoinPC nonpk = (NonPKJoinPC)nonpks.iterator().next();
        TestIrregularJoins.assertEquals((int)1, (int)nonpk.getId1());
        TestIrregularJoins.assertEquals((int)2, (int)nonpk.getId2());
        pm.close();
    }

    public void testPartialManyMany() {
        this.partialManyMany(this.currentEntityManager());
    }

    public void testEagerPartialManyMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("partials");
        this.partialManyMany(pm);
    }

    private void partialManyMany(OpenJPAEntityManager pm) {
        NonPKJoinPC nonpk = (NonPKJoinPC)pm.getObjectId(this._nonpk);
        Set partials = nonpk.getPartials();
        TestIrregularJoins.assertEquals((int)1, (int)partials.size());
        PartialJoinPC partial = (PartialJoinPC)partials.iterator().next();
        TestIrregularJoins.assertEquals((int)1, (int)partial.getPk1());
        TestIrregularJoins.assertEquals((int)2, (int)partial.getPk2());
        pm.close();
    }

    public void testVerticalNonPKManyMany() {
        this.verticalNonPKManyMany(this.currentEntityManager());
    }

    public void testEagerVerticalNonPKManyMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPK2s");
        this.verticalNonPKManyMany(pm);
    }

    private void verticalNonPKManyMany(OpenJPAEntityManager pm) {
        PartialJoinPC3 partial3 = (PartialJoinPC3)pm.getObjectId(this._partial3);
        Set nonpks = partial3.getNonPKs();
        TestIrregularJoins.assertEquals((int)1, (int)nonpks.size());
        NonPKJoinPC nonpk = (NonPKJoinPC)nonpks.iterator().next();
        TestIrregularJoins.assertEquals((int)1, (int)nonpk.getId1());
        TestIrregularJoins.assertEquals((int)2, (int)nonpk.getId2());
        Set nonpk2s = partial3.getNonPK2s();
        TestIrregularJoins.assertEquals((int)1, (int)nonpk2s.size());
        NonPKJoinPC2 nonpk2 = (NonPKJoinPC2)nonpk2s.iterator().next();
        TestIrregularJoins.assertEquals((int)2, (int)nonpk2.getId1());
        TestIrregularJoins.assertEquals((int)3, (int)nonpk2.getId2());
        pm.close();
    }

    public void testVerticalPartialManyMany() {
        this.verticalPartialManyMany(this.currentEntityManager());
    }

    public void testEagerVerticalPartialManyMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("partial2s");
        this.verticalPartialManyMany(pm);
    }

    private void verticalPartialManyMany(OpenJPAEntityManager pm) {
        NonPKJoinPC3 nonpk3 = (NonPKJoinPC3)pm.getObjectId(this._nonpk3);
        Set partials = nonpk3.getPartials();
        TestIrregularJoins.assertEquals((int)1, (int)partials.size());
        PartialJoinPC partial = (PartialJoinPC)partials.iterator().next();
        TestIrregularJoins.assertEquals((int)1, (int)partial.getPk1());
        TestIrregularJoins.assertEquals((int)2, (int)partial.getPk2());
        Set partial2s = nonpk3.getPartial2s();
        TestIrregularJoins.assertEquals((int)1, (int)partial2s.size());
        PartialJoinPC2 partial2 = (PartialJoinPC2)partial2s.iterator().next();
        TestIrregularJoins.assertEquals((int)2, (int)partial2.getPk1());
        TestIrregularJoins.assertEquals((int)3, (int)partial2.getPk2());
        pm.close();
    }

    public void testVerticalConstant() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ConstantJoinPC2 constant2 = (ConstantJoinPC2)pm.getObjectId(this._constant2);
        TestIrregularJoins.assertEquals((int)1, (int)constant2.getPk1());
        TestIrregularJoins.assertEquals((int)2, (int)constant2.getPk2());
        ConstantJoinPC3 constant3 = (ConstantJoinPC3)pm.getObjectId(this._constant3);
        TestIrregularJoins.assertEquals((int)1, (int)constant3.getPk1());
        TestIrregularJoins.assertEquals((int)3, (int)constant3.getPk2());
    }

    public void testConstantOneOne() {
        this.constantOneOne(this.currentEntityManager());
    }

    public void testEagerConstantOneOne() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPK");
        this.constantOneOne(pm);
    }

    private void constantOneOne(OpenJPAEntityManager pm) {
        ConstantJoinPC2 constant2 = (ConstantJoinPC2)pm.getObjectId(this._constant2);
        TestIrregularJoins.assertEquals((Object)this._nonpk3, (Object)pm.getObjectId((Object)constant2.getNonPK()));
        TestIrregularJoins.assertEquals((Object)this._nonpk3, (Object)pm.getObjectId((Object)constant2.getNonPK2()));
        pm.close();
    }

    public void testConstantOneMany() {
        this.constantOneMany(this.currentEntityManager());
    }

    public void testEagerConstantOneMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nonPKs");
        this.constantOneMany(pm);
    }

    private void constantOneMany(OpenJPAEntityManager pm) {
        ConstantJoinPC2 constant2 = (ConstantJoinPC2)pm.getObjectId(this._constant2);
        Collection nonpks = constant2.getNonPKs();
        TestIrregularJoins.assertEquals((int)1, (int)nonpks.size());
        TestIrregularJoins.assertEquals((Object)this._nonpk, (Object)pm.getObjectId(nonpks.iterator().next()));
        pm.close();
    }
}

