/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.kernel.common.apps.OuterJoinValuePC;

public class TestEJBOuterJoinValues
extends BaseJDBCTest {
    public int oid = 0;

    public TestEJBOuterJoinValues(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(OuterJoinValuePC.class);
        OuterJoinValuePC pc = new OuterJoinValuePC(10);
        pc.setStringField("pc");
        pc.setValue1(1);
        pc.setValue2(2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this.oid = pc.getId();
        this.endEm((EntityManager)pm);
    }

    public void testNull() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        OuterJoinValuePC pc = (OuterJoinValuePC)pm.find(OuterJoinValuePC.class, (Object)this.oid);
        pc.setValue1(0);
        pc.setValue2(0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (OuterJoinValuePC)pm.find(OuterJoinValuePC.class, (Object)this.oid);
        TestEJBOuterJoinValues.assertEquals((int)0, (int)pc.getValue1());
        TestEJBOuterJoinValues.assertEquals((int)0, (int)pc.getValue2());
        this.endEm((EntityManager)pm);
    }

    public void testUpdate() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        OuterJoinValuePC pc = (OuterJoinValuePC)pm.find(OuterJoinValuePC.class, (Object)this.oid);
        pc.setValue1(3);
        pc.setValue2(0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (OuterJoinValuePC)pm.find(OuterJoinValuePC.class, (Object)this.oid);
        TestEJBOuterJoinValues.assertEquals((int)3, (int)pc.getValue1());
        TestEJBOuterJoinValues.assertEquals((int)0, (int)pc.getValue2());
        this.endEm((EntityManager)pm);
    }

    public void testInsert() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OuterJoinValuePC pc = (OuterJoinValuePC)pm.find(OuterJoinValuePC.class, (Object)this.oid);
        TestEJBOuterJoinValues.assertEquals((String)"pc", (String)pc.getStringField());
        TestEJBOuterJoinValues.assertEquals((int)1, (int)pc.getValue1());
        TestEJBOuterJoinValues.assertEquals((int)2, (int)pc.getValue2());
        this.endEm((EntityManager)pm);
    }
}

