/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.InvertA;
import org.apache.openjpa.persistence.jdbc.common.apps.InvertB;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestEJBInverseOneToOne
extends BaseJDBCTest {
    public TestEJBInverseOneToOne(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(InvertA.class);
        this.deleteAll(InvertB.class);
    }

    private static Object insertData(EntityManager pm) {
        InvertA a = new InvertA(1);
        InvertB b = new InvertB(2);
        a.setTest("testA");
        b.setTest("testB");
        b.setInvertA(a);
        EntityTransaction t = pm.getTransaction();
        t.begin();
        pm.persist((Object)b);
        return pm.find(InvertB.class, (Object)2);
    }

    public void testLoad() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Object aId = TestEJBInverseOneToOne.insertData((EntityManager)pm);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        InvertB b = (InvertB)aId;
        TestEJBInverseOneToOne.assertNotNull((Object)b.getInvertA().getTest());
        TestEJBInverseOneToOne.assertEquals((String)b.getInvertA().getTest(), (String)"testA");
    }
}

