/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.kernel.common.apps.DateVersion;

public class TestEJBDateVersion
extends BaseJDBCTest {
    private int oid;

    public TestEJBDateVersion(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.deleteAll(DateVersion.class);
        DateVersion pc = new DateVersion("pc1", 1);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.oid = pc.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testOptLock() throws InterruptedException {
        OpenJPAEntityManager pm1 = this.currentEntityManager();
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        this.startTx((EntityManager)pm1);
        this.startTx((EntityManager)pm2);
        DateVersion pc1 = (DateVersion)pm1.find(DateVersion.class, (Object)this.oid);
        DateVersion pc2 = (DateVersion)pm2.find(DateVersion.class, (Object)this.oid);
        pc1.setString("pc-2-1");
        pc2.setString("pc-2-2");
        Thread.currentThread();
        Thread.sleep(1000L);
        this.endTx((EntityManager)pm1);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
            this.endTx((EntityManager)pm2);
            TestEJBDateVersion.fail((String)"Should have caused OL exception.");
        }
        catch (Exception jfe) {
            this.startTx((EntityManager)pm2);
            pm2.refresh((Object)pc2);
            pc2.setString("pc-3-2");
            this.endTx((EntityManager)pm2);
        }
        this.startTx((EntityManager)pm2);
        pc2.setString("pc-string-4-2");
        this.endTx((EntityManager)pm2);
        this.startTx((EntityManager)pm1);
        pm1.refresh((Object)pc1);
        pc1.setString("pc-string-3-1");
        this.startTx((EntityManager)pm2);
        pc2.setString("pc-string-5-2");
        Thread.currentThread();
        Thread.sleep(1000L);
        this.endTx((EntityManager)pm1);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
            this.endTx((EntityManager)pm2);
            TestEJBDateVersion.fail((String)"Should have caused OL exception2.");
        }
        catch (Exception jfe) {
            this.startTx((EntityManager)pm2);
            pm2.refresh((Object)pc2);
            pc2.setString("pc-string-6-2");
            this.endTx((EntityManager)pm2);
        }
        this.endEm((EntityManager)pm1);
        this.endEm((EntityManager)pm2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        DateVersion pc = (DateVersion)pm.find(DateVersion.class, (Object)this.oid);
        TestEJBDateVersion.assertEquals((String)"pc-string-6-2", (String)pc.toString());
        this.endEm((EntityManager)pm);
    }
}

