/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.kernel.common.apps.ByteArray;

public class TestEJBByteArray
extends BaseJDBCTest {
    private int _null;
    private int _empty;
    private int _small;
    private int _large;

    public TestEJBByteArray(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.deleteAll(ByteArray.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ByteArray pc = new ByteArray("Null", 1);
        pm.persist((Object)pc);
        this._null = 1;
        pc = new ByteArray("Empty", 2);
        pc.setBytes(new byte[0]);
        pm.persist((Object)pc);
        this._empty = 2;
        pc = new ByteArray("Small", 3);
        pc.setBytes(pc.getString().getBytes());
        pm.persist((Object)pc);
        this._small = 3;
        byte[] bytes = new byte[10000];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(i % 8);
        }
        pc = new ByteArray("Large", 4);
        pc.setBytes(bytes);
        pm.persist((Object)pc);
        this._large = 4;
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testNull() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ByteArray pc = (ByteArray)pm.find(ByteArray.class, (Object)this._null);
        TestEJBByteArray.assertNull((Object)pc.getBytes());
        pc.setBytes("Not Null".getBytes());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ByteArray)pm.find(ByteArray.class, (Object)this._null);
        TestEJBByteArray.assertEquals((String)"Not Null", (String)new String(pc.getBytes()));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testEmpty() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ByteArray pc = (ByteArray)pm.find(ByteArray.class, (Object)this._empty);
        byte[] bytes = pc.getBytes();
        TestEJBByteArray.assertNotNull((Object)bytes);
        TestEJBByteArray.assertEquals((int)0, (int)bytes.length);
        pc.setBytes("Not Empty".getBytes());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ByteArray)pm.find(ByteArray.class, (Object)this._empty);
        TestEJBByteArray.assertEquals((String)"Not Empty", (String)new String(pc.getBytes()));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testLarge() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ByteArray pc = (ByteArray)pm.find(ByteArray.class, (Object)this._large);
        byte[] bytes = pc.getBytes();
        TestEJBByteArray.assertNotNull((Object)bytes);
        TestEJBByteArray.assertEquals((int)10000, (int)bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            TestEJBByteArray.assertEquals((byte)bytes[i], (byte)((byte)(i % 8)));
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

