/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex2;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex2.Department;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex2.Employee;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex2.EmployeePK;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSpec10_1_26_Ex2
extends SQLListenerTestCase {
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public int deptId = 1;
    public int empId = 1;
    public List rsAllDepartments = null;

    public void setUp() {
        super.setUp(CLEAR_TABLES, Department.class, Employee.class, EmployeePK.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllDepartments = this.getAll(Department.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Department.class) {
            qi.setCandidateCollection((Collection)this.rsAllDepartments);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e), KEY(e).name from Department d,  in (d.empMap) e where d.deptId = 1";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        List rs = q.getResultList();
        EmployeePK d = (EmployeePK)((Object[])rs.get(0))[0];
        String name = (String)((Object[])rs.get(0))[1];
        TestSpec10_1_26_Ex2.assertEquals((String)d.getName(), (String)name);
        em.clear();
        query = "select ENTRY(e) from Department d,  in (d.empMap) e  where d.deptId = 1";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestSpec10_1_26_Ex2.assertTrue((boolean)d.equals(me.getKey()));
        this.sql.clear();
        query = "select count(KEY(e).bDay) from Department d  left join d.empMap e GROUP BY KEY(e).bDay";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex2.assertTrue((((String)this.sql.get(0)).toUpperCase().indexOf(" GROUP BY ") != -1 ? 1 : 0) != 0);
        }
        em.close();
    }

    public void testQueryObject() {
        this.queryObj((EntityManagerFactory)this.emf);
    }

    public void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numDepartments; ++i) {
            this.createDepartment(em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createDepartment(EntityManager em, int id) {
        Department d = new Department();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee e = this.createEmployee(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee("e" + id, new Date());
        return e;
    }

    public void findObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        Department d = (Department)em.find(Department.class, (Object)1);
        this.assertDepartment(d);
        Map<EmployeePK, Employee> emps = d.getEmpMap();
        Set<EmployeePK> keys = emps.keySet();
        for (EmployeePK key : keys) {
            Employee e = (Employee)em.find(Employee.class, (Object)key);
            this.assertEmployee(e);
        }
        this.updateObj(em, d);
        this.deleteObj(em, d);
        em.close();
    }

    public void updateObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Employee e = this.createEmployee(em, this.numDepartments * this.numEmployeesPerDept + 1);
        d.addEmployee(e);
        e.setDepartment(d);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
        tran.begin();
        d.removeEmployee(e.getEmpPK());
        e.setDepartment(null);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
    }

    public void deleteObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)d);
        tran.commit();
    }

    public void assertDepartment(Department d) {
        int id = d.getDeptId();
        Map<EmployeePK, Employee> es = d.getEmpMap();
        Assert.assertEquals((int)2, (int)es.size());
        Set<EmployeePK> keys = es.keySet();
        Iterator<EmployeePK> i$ = keys.iterator();
        while (i$.hasNext()) {
            EmployeePK obj;
            EmployeePK empPK = obj = i$.next();
            Employee e = es.get(empPK);
            Assert.assertEquals((Object)empPK, (Object)e.getEmpPK());
        }
    }

    public void queryObj(EntityManagerFactory emf) {
        this.queryDepartment(emf);
        this.queryEmployee(emf);
    }

    public void queryDepartment(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department d");
        List ds = q.getResultList();
        for (Department d : ds) {
            this.assertDepartment(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) {
        EmployeePK pk = e.getEmpPK();
        Department d = e.getDepartment();
    }
}

