/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex1.Department;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex1.Employee;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSpec10_1_26_Ex1
extends SQLListenerTestCase {
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public List<String> namedQueries = new ArrayList<String>();
    public int deptId = 1;
    public int empId = 1;
    public List rsAllDepartments = null;

    public void setUp() {
        super.setUp(CLEAR_TABLES, Department.class, Employee.class);
        this.createObj();
        this.rsAllDepartments = this.getAll(Department.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Department.class) {
            qi.setCandidateCollection((Collection)this.rsAllDepartments);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query1 = "select d.deptId, KEY(e), VALUE(e).empId from Department d, in (d.empMap) e";
        List rs1 = em.createQuery(query1).getResultList();
        System.out.println("rs size=" + rs1.size());
        String query = "select KEY(e) from Department d,  in (d.empMap) e order by d.deptId, e.empId";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        List rs = q.getResultList();
        Integer d = (Integer)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from Department d,  in (d.empMap) e order by d.deptId, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestSpec10_1_26_Ex1.assertTrue((boolean)d.equals(me.getKey()));
        this.sql.clear();
        query = "select KEY(e) from Department d,  in (d.empMap) e where KEY(e) > 1";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        TestSpec10_1_26_Ex1.assertTrue((((String)this.sql.get(0)).toUpperCase().indexOf(">") > 0 ? 1 : 0) != 0);
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj();
        this.findObj();
    }

    public void createObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numDepartments; ++i) {
            this.createDepartment((EntityManager)em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createDepartment(EntityManager em, int id) {
        Department d = new Department();
        d.setDeptId(id);
        HashMap<Integer, Employee> emps = new HashMap<Integer, Employee>();
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee e = this.createEmployee(em, this.empId++);
            d.addEmployee(e);
            emps.put(e.getEmpId(), e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        return e;
    }

    public void findObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Department d = (Department)em.find(Department.class, (Object)1);
        this.assertDepartment(d);
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        this.updateObj((EntityManager)em, d);
        this.deleteObj((EntityManager)em, d);
        em.close();
    }

    public void updateObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Employee e = this.createEmployee(em, this.numDepartments * this.numEmployeesPerDept + 1);
        d.addEmployee(e);
        e.setDepartment(d);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
        tran.begin();
        d.removeEmployee(e.getEmpId());
        e.setDepartment(null);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
    }

    public void deleteObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)d);
        tran.commit();
    }

    public void assertDepartment(Department d) {
        int id = d.getDeptId();
        Map<Integer, Employee> es = d.getEmpMap();
        Assert.assertEquals((int)2, (int)es.size());
        Set<Integer> keys = es.keySet();
        Iterator<Integer> i$ = keys.iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer empId = obj = i$.next();
            Employee e = es.get(empId);
            Assert.assertEquals((int)empId, (int)e.getEmpId());
        }
    }

    public void queryObj() {
        this.queryDepartment();
        this.queryEmployee();
    }

    public void queryDepartment() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department d");
        List ds = q.getResultList();
        for (Department d : ds) {
            this.assertDepartment(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) {
        int id = e.getEmpId();
        Department d = e.getDepartment();
        this.assertDepartment(d);
    }
}

