/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Department1;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Department2;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Department3;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Employee1;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Employee2;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.Employee3;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.EmployeeName3;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex0.EmployeePK2;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSpec10_1_26
extends SQLListenerTestCase {
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public List<String> namedQueries = new ArrayList<String>();
    public int deptId = 1;
    public int empId = 1;
    public List<Department1> rsAllDepartment1 = null;
    public List<Department2> rsAllDepartment2 = null;
    public List<Department3> rsAllDepartment3 = null;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Department1.class, Department2.class, Department3.class, Employee1.class, Employee2.class, Employee3.class, EmployeeName3.class, EmployeePK2.class);
        this.createObj();
        this.rsAllDepartment1 = this.getAll(Department1.class);
        this.rsAllDepartment2 = this.getAll(Department2.class);
        this.rsAllDepartment3 = this.getAll(Department3.class);
    }

    public void testHavingClauseWithEntityExpression() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee1 e1 = (Employee1)em.find(Employee1.class, (Object)1);
        em.clear();
        String query = "select e from Department1 d,  in (d.empMap) e group by e having e = ?1";
        Query q = em.createQuery(query);
        q.setParameter(1, (Object)e1);
        List rs = q.getResultList();
        Employee1 e2 = (Employee1)rs.get(0);
        TestSpec10_1_26.assertEquals((int)e1.getEmpId(), (int)e2.getEmpId());
        em.clear();
        query = "select e from Department1 d,  in (d.empMap) e group by e having e <> ?1";
        q = em.createQuery(query);
        q.setParameter(1, (Object)e1);
        rs = q.getResultList();
        Employee1 e3 = (Employee1)rs.get(0);
        TestSpec10_1_26.assertNotEquals(e1.getEmpId(), e3.getEmpId());
        em.clear();
        query = "select value(e) from Department1 d,  in (d.empMap) e group by value(e) having value(e) = ?1";
        q = em.createQuery(query);
        q.setParameter(1, (Object)e1);
        rs = q.getResultList();
        Employee1 e4 = (Employee1)rs.get(0);
        TestSpec10_1_26.assertEquals((int)e1.getEmpId(), (int)e4.getEmpId());
        em.close();
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class<?> clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Department1.class) {
            qi.setCandidateCollection(this.rsAllDepartment1);
        } else if (clz == Department2.class) {
            qi.setCandidateCollection(this.rsAllDepartment2);
        } else if (clz == Department3.class) {
            qi.setCandidateCollection(this.rsAllDepartment3);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e) from Department1 d,  in (d.empMap) e";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department1.class);
        }
        List rs = q.getResultList();
        Integer d = (Integer)rs.get(0);
        query = "select KEY(e) from Department2 d,  in (d.empMap) e";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department2.class);
        }
        rs = q.getResultList();
        EmployeePK2 d2 = (EmployeePK2)rs.get(0);
        query = "select KEY(e) from Department3 d,  in (d.emps) e";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department3.class);
        }
        rs = q.getResultList();
        EmployeeName3 d3 = (EmployeeName3)rs.get(0);
        query = "select KEY(e) from Department1 d,  in (d.empMap) e group by KEY(e) having KEY(e) = 2";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department1.class);
        }
        rs = q.getResultList();
        Integer deptId = (Integer)rs.get(0);
        TestSpec10_1_26.assertEquals((String)"dept id is not 2", (int)2, (int)deptId);
        query = "select KEY(e).lName from Department3 d, in (d.emps) e group by KEY(e).lName having KEY(e).lName like 'l%'";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department1.class);
        }
        rs = q.getResultList();
        TestSpec10_1_26.assertEquals((String)"number of employees is not equal to numDepartments*numEmployeesPerDept", (int)(this.numDepartments * this.numEmployeesPerDept), (int)rs.size());
        em.close();
    }

    public void testQueryObject() {
        this.queryObj();
    }

    public void createObj() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment1((EntityManager)em, this.deptId++);
        }
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment2((EntityManager)em, this.deptId++);
        }
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment3((EntityManager)em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createDepartment1(EntityManager em, int id) {
        Department1 d = new Department1();
        d.setDeptId(id);
        HashMap<Integer, Employee1> empMap = new HashMap<Integer, Employee1>();
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee1 e = this.createEmployee1(em, this.empId++);
            empMap.put(e.getEmpId(), e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        d.setEmpMap(empMap);
        em.persist((Object)d);
    }

    public Employee1 createEmployee1(EntityManager em, int id) {
        Employee1 e = new Employee1();
        e.setEmpId(id);
        return e;
    }

    public void createDepartment2(EntityManager em, int id) {
        Department2 d = new Department2();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee2 e = this.createEmployee2(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee2 createEmployee2(EntityManager em, int id) {
        Employee2 e = new Employee2("e" + id, new Date());
        return e;
    }

    public void createDepartment3(EntityManager em, int id) {
        Department3 d = new Department3();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee3 e = this.createEmployee3(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee3 createEmployee3(EntityManager em, int id) {
        Employee3 e = new Employee3();
        EmployeeName3 name = new EmployeeName3("f" + id, "l" + id);
        e.setEmpId(id);
        e.setName(name);
        return e;
    }

    public void findObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Department1 d1 = (Department1)em.find(Department1.class, (Object)1);
        this.assertDepartment1(d1);
        Employee1 e1 = (Employee1)em.find(Employee1.class, (Object)1);
        this.assertEmployee1(e1);
        Department2 d2 = (Department2)em.find(Department2.class, (Object)3);
        this.assertDepartment2(d2);
        Map<EmployeePK2, Employee2> empMap = d2.getEmpMap();
        Set<EmployeePK2> keys = empMap.keySet();
        for (EmployeePK2 key : keys) {
            Employee2 e2 = (Employee2)em.find(Employee2.class, (Object)key);
            this.assertEmployee2(e2);
        }
        Department3 d3 = (Department3)em.find(Department3.class, (Object)5);
        this.assertDepartment3(d3);
        Employee3 e3 = (Employee3)em.find(Employee3.class, (Object)9);
        this.assertEmployee3(e3);
        em.close();
    }

    public void assertDepartment1(Department1 d) {
        int id = d.getDeptId();
        Map<Integer, Employee1> es = d.getEmpMap();
        Assert.assertEquals((int)2, (int)es.size());
        Set<Integer> keys = es.keySet();
        Iterator<Integer> i$ = keys.iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer empId = obj = i$.next();
            Employee1 e = es.get(empId);
            Assert.assertEquals((int)empId, (int)e.getEmpId());
        }
    }

    public void assertDepartment2(Department2 d) {
        int id = d.getDeptId();
        Map<EmployeePK2, Employee2> es = d.getEmpMap();
        Assert.assertEquals((int)2, (int)es.size());
        Set<EmployeePK2> keys = es.keySet();
        for (EmployeePK2 pk : keys) {
            Employee2 e = es.get(pk);
            Assert.assertEquals((Object)pk, (Object)e.getEmpPK());
        }
    }

    public void assertDepartment3(Department3 d) {
        int id = d.getDeptId();
        Map<EmployeeName3, Employee3> es = d.getEmployees();
        Assert.assertEquals((int)2, (int)es.size());
        Set<EmployeeName3> keys = es.keySet();
        for (EmployeeName3 key : keys) {
            Employee3 e = es.get(key);
            Assert.assertEquals((Object)key, (Object)e.getName());
        }
    }

    public void assertEmployee1(Employee1 e) {
        int id = e.getEmpId();
        Department1 d = e.getDepartment();
        this.assertDepartment1(d);
    }

    public void assertEmployee2(Employee2 e) {
        EmployeePK2 pk = e.getEmpPK();
        Department2 d = e.getDepartment();
        this.assertDepartment2(d);
    }

    public void assertEmployee3(Employee3 e) {
        int id = e.getEmpId();
        Department3 d = e.getDepartment();
        this.assertDepartment3(d);
    }

    public void queryObj() {
        this.queryDepartment1((EntityManagerFactory)this.emf);
        this.queryEmployee1((EntityManagerFactory)this.emf);
        this.queryDepartment2((EntityManagerFactory)this.emf);
        this.queryEmployee2((EntityManagerFactory)this.emf);
        this.queryDepartment3((EntityManagerFactory)this.emf);
        this.queryEmployee3((EntityManagerFactory)this.emf);
    }

    public void queryDepartment1(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department1 d");
        List ds = q.getResultList();
        for (Department1 d : ds) {
            this.assertDepartment1(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee1(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee1 e");
        List es = q.getResultList();
        for (Employee1 e : es) {
            this.assertEmployee1(e);
        }
        tran.commit();
        em.close();
    }

    public void queryDepartment2(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department2 d");
        List ds = q.getResultList();
        for (Department2 d : ds) {
            this.assertDepartment2(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee2(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee2 e");
        List es = q.getResultList();
        for (Employee2 e : es) {
            this.assertEmployee2(e);
        }
        tran.commit();
        em.close();
    }

    public void queryDepartment3(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department3 d");
        List ds = q.getResultList();
        for (Department3 d : ds) {
            this.assertDepartment3(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee3(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee3 e");
        List es = q.getResultList();
        for (Employee3 e : es) {
            this.assertEmployee3(e);
        }
        tran.commit();
        em.close();
    }
}

