/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.qualified.path;

import java.util.HashMap;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.maps.qualified.path.Division;
import org.apache.openjpa.persistence.jdbc.maps.qualified.path.Employee;
import org.apache.openjpa.persistence.jdbc.maps.qualified.path.PersonalInfo;
import org.apache.openjpa.persistence.jdbc.maps.qualified.path.Phone;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestQualifiedPath
extends SQLListenerTestCase {
    private int numDivisions = 2;
    private int numEmployeesPerDivision = 3;
    private int numMobilePhonesPerEmployee = 2;
    private int divisionId = 0;
    private int employeeId = 0;
    private int nameCount = 0;
    private int phoneId = 0;
    private int phoneNumber = 1234567890;
    OpenJPAEntityManager em;

    public void setUp() {
        super.setUp(CLEAR_TABLES, Division.class, Employee.class, Phone.class, PersonalInfo.class);
        TestQualifiedPath.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestQualifiedPath.assertNotNull((Object)this.em);
        this.createObj();
    }

    public void testQueries() {
        this.em.clear();
        String query = "select p  from Division d, in(d.employees) e, in(KEY(e).personalInfo.phones) p";
        OpenJPAQuery q = this.em.createQuery(query);
        List rs = q.getResultList();
        TestQualifiedPath.assertEquals((int)(this.numDivisions * this.numEmployeesPerDivision * (2 + this.numMobilePhonesPerEmployee)), (int)rs.size());
        this.em.clear();
        query = "select KEY(e) from Division d, in(d.employees) e where KEY(e).personalInfo.lastName = 'lName2'";
        q = this.em.createQuery(query);
        rs = q.getResultList();
        TestQualifiedPath.assertEquals((int)1, (int)rs.size());
        Employee employee = (Employee)rs.get(0);
        TestQualifiedPath.assertEquals((String)"lName2", (String)employee.getPersonalInfo().getLastName());
        this.em.clear();
        query = "select KEY(e) from Division d, in(d.employees) e order by KEY(e).personalInfo.lastName";
        q = this.em.createQuery(query);
        rs = q.getResultList();
        TestQualifiedPath.assertEquals((int)(this.numDivisions * this.numEmployeesPerDivision), (int)rs.size());
        employee = (Employee)rs.get(0);
        TestQualifiedPath.assertTrue((boolean)employee.getPersonalInfo().getLastName().equals("lName1"));
        employee = (Employee)rs.get(1);
        TestQualifiedPath.assertTrue((boolean)employee.getPersonalInfo().getLastName().equals("lName2"));
        this.em.clear();
        query = "select KEY(e).personalInfo.lastName from Division d, in (d.employees) e group by KEY(e).personalInfo.lastName having KEY(e).personalInfo.lastName = 'lName3'";
        q = this.em.createQuery(query);
        rs = q.getResultList();
        TestQualifiedPath.assertEquals((int)1, (int)rs.size());
    }

    private void createObj() {
        this.em.getTransaction().begin();
        for (int i = 0; i < this.numDivisions; ++i) {
            this.createDivision(this.divisionId++);
        }
        this.em.flush();
        this.em.getTransaction().commit();
    }

    private void createDivision(int id) {
        Division division = new Division();
        division.setId(id);
        HashMap<Employee, String> employees = new HashMap<Employee, String>();
        for (int i = 0; i < this.numEmployeesPerDivision; ++i) {
            Employee employee = this.createEmployee(this.employeeId++);
            employees.put(employee, employee.getPersonalInfo().getLastName());
        }
        division.setEmployees(employees);
        this.em.persist((Object)division);
    }

    private Employee createEmployee(int id) {
        Employee employee = new Employee();
        employee.setId(id);
        PersonalInfo personalInfo = new PersonalInfo();
        personalInfo.setFirstName("fName" + this.nameCount++);
        personalInfo.setLastName("lName" + this.nameCount);
        Phone homePhone = new Phone(this.phoneId++, "home", this.phoneNumber++);
        personalInfo.addPhone(homePhone);
        Phone officePhone = new Phone(this.phoneId++, "office", this.phoneNumber++);
        personalInfo.addPhone(officePhone);
        for (int i = 0; i < this.numMobilePhonesPerEmployee; ++i) {
            Phone mobilePhone = new Phone(this.phoneId++, "mobile", this.phoneNumber++);
            personalInfo.addPhone(mobilePhone);
        }
        employee.setPersonalInfo(personalInfo);
        this.em.persist((Object)employee);
        return employee;
    }
}

