/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex10;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.EmployeePK;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.PhoneNumber;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.PhonePK;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMany2ManyMapEx10
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbers = this.numEmployees + 1;
    public int numEmployeesPerPhoneNumber = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public List<String> namedQueries = new ArrayList<String>();
    public List<EmployeePK> empPKs = new ArrayList<EmployeePK>();
    public List<PhonePK> phonePKs = new ArrayList<PhonePK>();
    public Map<String, Employee> empMap = new HashMap<String, Employee>();
    public Map<PhonePK, PhoneNumber> phoneMap = new HashMap<PhonePK, PhoneNumber>();
    public int empId = 1;
    public int phoneId = 1;
    public int divId = 1;
    public List rsAllPhones = null;
    public List rsAllEmps = null;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, EmployeePK.class, PhonePK.class, Employee.class, PhoneNumber.class);
        this.createObj();
        this.rsAllPhones = this.getAll(PhoneNumber.class);
        this.rsAllEmps = this.getAll(Employee.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == PhoneNumber.class) {
            qi.setCandidateCollection((Collection)this.rsAllPhones);
        } else if (clz == Employee.class) {
            qi.setCandidateCollection((Collection)this.rsAllEmps);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmployeePK ekey = this.empPKs.get(0);
        String query = "select KEY(e) from PhoneNumber p,  in (p.emps) e where e.empPK.name = ?1 and e.empPK.bDay = ?2";
        Query q = em.createQuery(query).setParameter(1, (Object)ekey.getName()).setParameter(2, (Object)ekey.getBDay());
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        List rs = q.getResultList();
        EmployeePK d = (EmployeePK)rs.get(0);
        query = "select KEY(e) from PhoneNumber p,  in (p.emps) e where e.empPK = ?1";
        try {
            rs = em.createQuery(query).setParameter(1, (Object)ekey).getResultList();
        }
        catch (Exception e) {
            this.assertException(e, ArgumentException.class);
        }
        query = "select KEY(p) from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        PhonePK k = (PhonePK)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from PhoneNumber p,  in (p.emps) e  where e.empPK.name = ?1 and e.empPK.bDay = ?2";
        q = em.createQuery(query).setParameter(1, (Object)ekey.getName()).setParameter(2, (Object)ekey.getBDay());
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestMany2ManyMapEx10.assertTrue((boolean)d.equals(me.getKey()));
        em.clear();
        query = "select KEY(e), KEY(e).name from PhoneNumber p,  in (p.emps) e";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        EmployeePK d0 = (EmployeePK)((Object[])rs.get(0))[0];
        String name = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMapEx10.assertEquals((String)d0.getName(), (String)name);
        em.clear();
        query = "select KEY(p), KEY(p).phoneNum from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        k = (PhonePK)((Object[])rs.get(0))[0];
        String phoneNum = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMapEx10.assertEquals((String)k.getPhoneNum(), (String)phoneNum);
        query = "select KEY(p), KEY(p).phoneNum as pno from Employee e  left join e.phones p ORDER BY pno ";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        this.sql.clear();
        query = "select COUNT(KEY(p).phoneNum) from Employee e  left join e.phones p GROUP BY KEY(p).phoneNum";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestMany2ManyMapEx10.assertTrue((((String)this.sql.get(0)).toUpperCase().indexOf(" GROUP BY ") != -1 ? 1 : 0) != 0);
        }
        query = "select LENGTH(KEY(e).name) from PhoneNumber p,  in (p.emps) e where KEY(e).bDay = CURRENT_TIMESTAMP";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        TestMany2ManyMapEx10.assertEquals((int)rs.size(), (int)0);
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj();
        this.findObj();
    }

    public void createObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee((EntityManager)em, this.empId++);
            this.empMap.put(e.getEmpPK().getName(), e);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        Date bDay = new Date(System.currentTimeMillis() - 1000000L);
        EmployeePK empPK = new EmployeePK("e" + id, bDay);
        this.empPKs.add(empPK);
        e.setEmpPK(empPK);
        e.setSalary(1000);
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = new PhoneNumber();
            PhonePK phonePK = new PhonePK("areaCode" + this.phoneId, "phoneNum" + this.phoneId);
            phoneNumber.setRoom(this.phoneId);
            ++this.phoneId;
            this.phonePKs.add(phonePK);
            phoneNumber.setPhonePK(phonePK);
            phoneNumber.addEmployees(empPK, e);
            e.addPhoneNumber(phonePK, phoneNumber);
            em.persist((Object)phoneNumber);
            this.phoneMap.put(phoneNumber.getPhonePK(), phoneNumber);
        }
        em.persist((Object)e);
        return e;
    }

    public void findObj() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)this.empPKs.get(1));
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)this.phonePKs.get(1));
        this.assertPhoneNumber(p);
        em.close();
    }

    public void queryObj() throws Exception {
        this.queryEmployee();
        this.queryPhoneNumber();
    }

    public void queryPhoneNumber() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) throws Exception {
        EmployeePK empPK = e.getEmpPK();
        Employee e0 = this.empMap.get(empPK.getName());
        Map<PhonePK, PhoneNumber> phones = e.getPhoneNumbers();
        Map<PhonePK, PhoneNumber> phones0 = e0.getPhoneNumbers();
        Assert.assertEquals((int)phones0.size(), (int)phones.size());
        this.checkPhoneMap(phones0, phones);
    }

    public void assertPhoneNumber(PhoneNumber p) throws Exception {
        PhonePK phonePK = p.getPhonePK();
        PhoneNumber p0 = this.phoneMap.get(phonePK);
        Map<EmployeePK, Employee> es = p.getEmployees();
        Map<EmployeePK, Employee> es0 = p0.getEmployees();
        Assert.assertEquals((int)es0.size(), (int)es.size());
        this.checkEmpMap(es0, es);
    }

    public void checkPhoneMap(Map<PhonePK, PhoneNumber> es0, Map<PhonePK, PhoneNumber> es) throws Exception {
        Set<Map.Entry<PhonePK, PhoneNumber>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            PhoneNumber p;
            PhonePK d0 = (PhonePK)entry.getKey();
            PhoneNumber p0 = (PhoneNumber)entry.getValue();
            if (p0.equals(p = es.get(d0))) continue;
            throw new Exception("Assertion failure");
        }
    }

    public void checkEmpMap(Map<EmployeePK, Employee> es0, Map<EmployeePK, Employee> es) throws Exception {
        Set<Map.Entry<EmployeePK, Employee>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            Employee e;
            EmployeePK key0 = (EmployeePK)entry.getKey();
            Employee e0 = (Employee)entry.getValue();
            if (e0.equals(e = Employee.findEmpl(es, key0))) continue;
            throw new Exception("Assertion failure");
        }
    }
}

