/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex10;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.EmployeePK;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.PhonePK;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="M10Phone")
public class PhoneNumber {
    @EmbeddedId
    PhonePK phonePK;
    @ManyToMany(mappedBy="phones")
    Map<EmployeePK, Employee> emps = new HashMap<EmployeePK, Employee>();
    int room;

    public PhonePK getPhonePK() {
        return this.phonePK;
    }

    public void setPhonePK(PhonePK phonePK) {
        this.phonePK = phonePK;
    }

    public Map<EmployeePK, Employee> getEmployees() {
        return this.emps;
    }

    public void addEmployees(EmployeePK d, Employee employee) {
        this.emps.put(d, employee);
    }

    public void removeEmployee(EmployeePK d) {
        this.emps.remove(d);
    }

    public int getRoom() {
        return this.room;
    }

    public void setRoom(int room) {
        this.room = room;
    }

    public boolean equals(Object o) {
        PhoneNumber p = (PhoneNumber)o;
        Map<EmployeePK, Employee> map = p.getEmployees();
        if (map.size() != this.emps.size()) {
            return false;
        }
        Set<Map.Entry<EmployeePK, Employee>> entries = this.emps.entrySet();
        for (Map.Entry entry : entries) {
            EmployeePK key = (EmployeePK)entry.getKey();
            Employee e0 = Employee.findEmpl(map, key);
            Employee e = Employee.findEmpl(this.emps, key);
            if (e == null && e0 != null || e != null && e0 == null) {
                return false;
            }
            if (e.getEmpPK().equals(e0.getEmpPK())) continue;
            return false;
        }
        return true;
    }
}

