/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex10;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.EmployeePK;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.PhoneNumber;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex10.PhonePK;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="M10Emp")
public class Employee {
    @EmbeddedId
    EmployeePK empPK;
    @ManyToMany
    Map<PhonePK, PhoneNumber> phones = new HashMap<PhonePK, PhoneNumber>();
    int salary;

    public EmployeePK getEmpPK() {
        return this.empPK;
    }

    public void setEmpPK(EmployeePK empPK) {
        this.empPK = empPK;
    }

    public Map<PhonePK, PhoneNumber> getPhoneNumbers() {
        return this.phones;
    }

    public void addPhoneNumber(PhonePK d, PhoneNumber phoneNumber) {
        this.phones.put(d, phoneNumber);
    }

    public void removePhoneNumber(PhonePK d) {
        this.phones.remove(d);
    }

    public int getSalary() {
        return this.salary;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    public boolean equals(Object o) {
        Employee e = (Employee)o;
        Map<PhonePK, PhoneNumber> map = e.getPhoneNumbers();
        if (map.size() != this.phones.size()) {
            return false;
        }
        Set<Map.Entry<PhonePK, PhoneNumber>> entries = this.phones.entrySet();
        for (Map.Entry entry : entries) {
            PhonePK key = (PhonePK)entry.getKey();
            PhoneNumber p = (PhoneNumber)entry.getValue();
            PhoneNumber p0 = map.get(key);
            if (p.getPhonePK().equals(p0.getPhonePK())) continue;
            return false;
        }
        return true;
    }

    public static Employee findEmpl(Map<EmployeePK, Employee> map, EmployeePK key) {
        String name = key.getName();
        String bDateStr = key.getBDay().toString();
        Set<EmployeePK> keys = map.keySet();
        for (EmployeePK thisKey : keys) {
            if (!name.equals(thisKey.getName()) || !bDateStr.equals(thisKey.getBDay().toString())) continue;
            return map.get(thisKey);
        }
        return null;
    }
}

