/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex1;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex1.Department;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex1.Division;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex1.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex1.PhoneNumber;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMany2ManyMapEx1
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public Map<Integer, Employee> empMap = new HashMap<Integer, Employee>();
    public Map<Integer, PhoneNumber> phoneMap = new HashMap<Integer, PhoneNumber>();
    public int empId = 1;
    public int phoneId = 1;
    public int divId = 1;
    public int deptId = 10;
    public List rsAllPhones = null;
    public List rsAllEmps = null;
    public List rsAllDivisions = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Department.class, Division.class, Employee.class, PhoneNumber.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllPhones = this.getAll(PhoneNumber.class);
        this.rsAllEmps = this.getAll(Employee.class);
        this.rsAllDivisions = this.getAll(Division.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == PhoneNumber.class) {
            qi.setCandidateCollection((Collection)this.rsAllPhones);
        } else if (clz == Employee.class) {
            qi.setCandidateCollection((Collection)this.rsAllEmps);
        } else if (clz == Division.class) {
            qi.setCandidateCollection((Collection)this.rsAllDivisions);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e), p from PhoneNumber p,  in (p.emps) e order by e.empId";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        List rs = q.getResultList();
        Division d = (Division)((Object[])rs.get(0))[0];
        PhoneNumber p = (PhoneNumber)((Object[])rs.get(0))[1];
        query = "select KEY(p) from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        Department d2 = (Department)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from PhoneNumber p,  in (p.emps) e order by e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestMany2ManyMapEx1.assertTrue((boolean)d.equals(me.getKey()));
        em.clear();
        query = "select KEY(e), KEY(e).name from PhoneNumber p,  in (p.emps) e order by e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Division d0 = (Division)((Object[])rs.get(0))[0];
        String name = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMapEx1.assertEquals((String)d0.getName(), (String)name);
        em.clear();
        query = "select KEY(p), KEY(p).name from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        d2 = (Department)((Object[])rs.get(0))[0];
        String dname = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMapEx1.assertEquals((String)d2.getName(), (String)dname);
        em.clear();
        query = "select KEY(p), KEY(p).name from Employee e,  in (e.phones) p ORDER BY KEY(p).name DESC";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        String name1 = (String)((Object[])rs.get(0))[1];
        em.clear();
        query = "select KEY(p), KEY(p).name as name from Employee e,  in (e.phones) p ORDER BY name DESC";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        String name2 = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMapEx1.assertEquals((String)name1, (String)name2);
        query = "select count(KEY(p).name) from Employee e,  in (e.phones) p GROUP BY KEY(p).name";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        em.clear();
        query = "select p.division, KEY(p), KEY(p).name from Employee e,  in (e.phones) p ORDER BY KEY(p).name DESC";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        query = "select KEY(e) from PhoneNumber p,  in (p.emps) e";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        query = "select KEY(e) from PhoneNumber p  left join p.emps e";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        query = "select p.division, KEY(e), KEY(e).name as nm from PhoneNumber p,  in (p.emps) e order by nm";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        String n1 = ((Division)((Object[])rs.get(0))[1]).getName();
        String n2 = (String)((Object[])rs.get(0))[2];
        TestMany2ManyMapEx1.assertEquals((String)n1, (String)n2);
        query = "select d.name, KEY(e), KEY(e).name from PhoneNumber p,  in (p.emps) e, Division d";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        query = "select d.name, KEY(e), KEY(e).name from Division d join d.phone p,  in (p.emps) e order by d.name";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Division.class);
        }
        rs = q.getResultList();
        n1 = ((Division)((Object[])rs.get(0))[1]).getName();
        n2 = (String)((Object[])rs.get(0))[2];
        TestMany2ManyMapEx1.assertEquals((String)n1, (String)n2);
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj((EntityManagerFactory)this.emf);
        this.findObj((EntityManagerFactory)this.emf);
    }

    public void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee(em, this.empId++);
            this.empMap.put(e.getEmpId(), e);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = new PhoneNumber();
            phoneNumber.setNumber(this.phoneId++);
            Division div = this.createDivision(em, this.divId++);
            Department dept = this.createDepartment(em, this.deptId++);
            phoneNumber.addEmployees(div, e);
            e.addPhoneNumber(dept, phoneNumber);
            this.phoneMap.put(phoneNumber.getNumber(), phoneNumber);
            div.setPhone(phoneNumber);
            phoneNumber.setDivision(div);
            em.persist((Object)phoneNumber);
            em.persist((Object)dept);
            em.persist((Object)div);
        }
        em.persist((Object)e);
        return e;
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public Department createDepartment(EntityManager em, int id) {
        Department d = new Department();
        d.setId(id);
        d.setName("dept" + id);
        return d;
    }

    public void findObj(EntityManagerFactory emf) throws Exception {
        EntityManager em = emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        this.assertPhoneNumber(p);
        em.close();
    }

    public void queryObj(EntityManagerFactory emf) throws Exception {
        this.queryEmployee(emf);
        this.queryPhoneNumber(emf);
    }

    public void queryPhoneNumber(EntityManagerFactory emf) throws Exception {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee(EntityManagerFactory emf) throws Exception {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) throws Exception {
        int id = e.getEmpId();
        Employee e0 = this.empMap.get(id);
        Map<Department, PhoneNumber> phones0 = e0.getPhoneNumbers();
        Map<Department, PhoneNumber> phones = e.getPhoneNumbers();
        Assert.assertEquals((int)phones0.size(), (int)phones.size());
        this.checkPhoneMap(phones0, phones);
    }

    public void assertPhoneNumber(PhoneNumber p) throws Exception {
        int number = p.getNumber();
        PhoneNumber p0 = this.phoneMap.get(number);
        Map<Division, Employee> es0 = p0.getEmployees();
        Map<Division, Employee> es = p.getEmployees();
        Assert.assertEquals((int)es0.size(), (int)es.size());
        this.checkEmpMap(es0, es);
    }

    public void checkPhoneMap(Map<Department, PhoneNumber> es0, Map<Department, PhoneNumber> es) throws Exception {
        Set<Map.Entry<Department, PhoneNumber>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            PhoneNumber p;
            Department d0 = (Department)entry.getKey();
            PhoneNumber p0 = (PhoneNumber)entry.getValue();
            if (p0.equals(p = es.get(d0))) continue;
            throw new Exception("Assertion failure");
        }
    }

    public void checkEmpMap(Map<Division, Employee> es0, Map<Division, Employee> es) throws Exception {
        Set<Map.Entry<Division, Employee>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            Employee e;
            Division d0 = (Division)entry.getKey();
            Employee e0 = (Employee)entry.getValue();
            if (e0.equals(e = es.get(d0))) continue;
            throw new Exception("Assertion failure");
        }
    }
}

