/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping.bidi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.PreUpdate;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.Child;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.IParent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ParentWithSequenceIdentity
implements IParent {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private long id;
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @ElementJoinColumn(name="FK_PARENT_SEQ_ID", referencedAttributeName="id")
    private Set<Child> children;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setId(long id) {
        throw new RuntimeException(this.getClass() + ".setId() is not to be " + "invoked directly. This class is using SEQ Generation Starategy");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Collection<Child> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(Child child) {
        if (this.children == null) {
            this.children = new HashSet<Child>();
        }
        this.children.add(child);
    }

    public boolean removeChild(Child child) {
        return this.children != null && this.children.remove(child);
    }

    @PreUpdate
    @PostPersist
    public void postPersist() {
        if (this.children == null) {
            return;
        }
        for (Child child : this.children) {
            child.setSeqParentId(this.getId());
        }
    }
}

