/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.persistence.jdbc.mapping.PrecisionTestEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPrecisionMapping
extends SingleEMFTestCase {
    private static final String[] _DOUBLE_FIELDS = new String[]{"primDbl", "dbl"};
    private static final String _BIG_DECIMAL_FIELD = "bigDecimal";

    public void setUp() {
        this.setUp(PrecisionTestEntity.class);
    }

    public void testUnspecified() {
        this.testDoubleMapping("", 8, 0, 0);
        this.testBigDecimalMapping("", 2, 0, 0);
    }

    public void testPrecisionOnly() {
        this.testDoubleMapping("Precis", 2, 10, 0);
        this.testBigDecimalMapping("Precis", 2, 10, 0);
    }

    public void testScaleOnly() {
        this.testDoubleMapping("Scale", 2, 0, 10);
        this.testBigDecimalMapping("Scale", 2, 0, 10);
    }

    public void testPrecisionAndScale() {
        this.testDoubleMapping("PrecisScale", 2, 10, 10);
        this.testBigDecimalMapping("PrecisScale", 2, 10, 10);
    }

    private void testBigDecimalMapping(String fieldSuffix, int expectedType, int expectedPrecision, int expectedScale) {
        ClassMapping mapping = this.getMapping(PrecisionTestEntity.class);
        FieldMapping fm = mapping.getFieldMapping(_BIG_DECIMAL_FIELD + fieldSuffix);
        Column[] cols = fm.getColumns();
        TestPrecisionMapping.assertEquals((int)1, (int)cols.length);
        TestPrecisionMapping.assertEquals((int)expectedType, (int)cols[0].getType());
        TestPrecisionMapping.assertEquals((int)expectedPrecision, (int)cols[0].getSize());
        TestPrecisionMapping.assertEquals((int)expectedScale, (int)cols[0].getDecimalDigits());
    }

    private void testDoubleMapping(String fieldSuffix, int expectedType, int expectedPrecision, int expectedScale) {
        ClassMapping mapping = this.getMapping(PrecisionTestEntity.class);
        for (String s : _DOUBLE_FIELDS) {
            FieldMapping fm = mapping.getFieldMapping(s + fieldSuffix);
            Column[] cols = fm.getColumns();
            TestPrecisionMapping.assertEquals((int)1, (int)cols.length);
            TestPrecisionMapping.assertEquals((int)expectedType, (int)cols[0].getType());
            TestPrecisionMapping.assertEquals((int)expectedPrecision, (int)cols[0].getSize());
            TestPrecisionMapping.assertEquals((int)expectedScale, (int)cols[0].getDecimalDigits());
        }
    }
}

