/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.common.apps.AutoIncrementOpOrderPCSub;
import org.apache.openjpa.persistence.jdbc.common.apps.OpOrder;
import org.apache.openjpa.persistence.jdbc.common.apps.OpOrderPCSub;

public class TestOperationOrderUpdateManager
extends AbstractTestCase {
    private static boolean _mapped = false;
    private EntityManagerFactory emf;

    public TestOperationOrderUpdateManager(String name) {
        super(name);
    }

    private void insertTest(boolean autoAssign) {
        OpOrder oid = autoAssign ? this.insertAutoAssign() : this.insert();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpOrder pc = (OpOrder)em.find(OpOrder.class, (Object)oid.getId());
        TestOperationOrderUpdateManager.assertEquals((String)"pc", (String)pc.getSecondary());
        TestOperationOrderUpdateManager.assertEquals((String)"pcsub", (String)pc.getSub());
        TestOperationOrderUpdateManager.assertNotNull((Object)pc.getRel());
        TestOperationOrderUpdateManager.assertEquals((String)"rel", (String)pc.getRel().getSecondary());
        TestOperationOrderUpdateManager.assertEquals((int)2, (int)pc.getRelList().size());
        TestOperationOrderUpdateManager.assertTrue((boolean)((OpOrder)pc.getRelList().iterator().next()).getSecondary().startsWith("child"));
        TestOperationOrderUpdateManager.assertEquals((int)2, (int)pc.getMappedRelList().size());
        TestOperationOrderUpdateManager.assertTrue((boolean)((OpOrder)pc.getMappedRelList().iterator().next()).getSecondary().startsWith("mapped"));
        TestOperationOrderUpdateManager.assertEquals((int)2, (int)pc.getInverseKeyRelList().size());
        TestOperationOrderUpdateManager.assertTrue((boolean)((OpOrder)pc.getInverseKeyRelList().iterator().next()).getSecondary().startsWith("inverse"));
        em.close();
    }

    private OpOrder insert() {
        OpOrderPCSub pc = new OpOrderPCSub();
        pc.setSecondary("pc");
        pc.setSub("pcsub");
        OpOrderPCSub rel = new OpOrderPCSub();
        rel.setSecondary("rel");
        pc.setRel(rel);
        for (int i = 0; i < 2; ++i) {
            OpOrderPCSub child = new OpOrderPCSub();
            child.setSecondary("child" + i);
            pc.getRelList().add(child);
            OpOrderPCSub mapped = new OpOrderPCSub();
            mapped.setSecondary("mapped" + i);
            mapped.setOwner(pc);
            pc.getMappedRelList().add(mapped);
            OpOrderPCSub inverse = new OpOrderPCSub();
            inverse.setSecondary("inverse" + i);
            pc.getInverseKeyRelList().add(inverse);
        }
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)rel);
        this.persistAll((EntityManager)em, pc.getInverseKeyRelList());
        em.persist((Object)pc);
        this.endTx((EntityManager)em);
        OpOrder oid = (OpOrder)em.find(OpOrder.class, (Object)pc.getId());
        em.close();
        return oid;
    }

    private OpOrder insertAutoAssign() {
        AutoIncrementOpOrderPCSub pc = new AutoIncrementOpOrderPCSub();
        pc.setSecondary("pc");
        pc.setSub("pcsub");
        AutoIncrementOpOrderPCSub rel = new AutoIncrementOpOrderPCSub();
        rel.setSecondary("rel");
        pc.setRel(rel);
        for (int i = 0; i < 2; ++i) {
            AutoIncrementOpOrderPCSub child = new AutoIncrementOpOrderPCSub();
            child.setSecondary("child" + i);
            pc.getRelList().add(child);
            AutoIncrementOpOrderPCSub mapped = new AutoIncrementOpOrderPCSub();
            mapped.setSecondary("mapped" + i);
            mapped.setOwner(pc);
            pc.getMappedRelList().add(mapped);
            AutoIncrementOpOrderPCSub inverse = new AutoIncrementOpOrderPCSub();
            inverse.setSecondary("inverse" + i);
            pc.getInverseKeyRelList().add(inverse);
        }
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)rel);
        this.persistAll((EntityManager)em, pc.getInverseKeyRelList());
        em.persist((Object)pc);
        this.endTx((EntityManager)em);
        OpOrder oid = (OpOrder)em.find(AutoIncrementOpOrderPCSub.class, (Object)pc.getId());
        em.close();
        return oid;
    }

    private void insertCircularConstraintTest(boolean autoAssign) {
        OpOrder oid = autoAssign ? this.insertCircularAutoAssign() : this.insertCircular();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpOrder pc1 = (OpOrder)em.find(OpOrder.class, (Object)oid.getId());
        TestOperationOrderUpdateManager.assertEquals((String)"pc1", (String)pc1.getSecondary());
        TestOperationOrderUpdateManager.assertNotNull((Object)pc1.getRel());
        TestOperationOrderUpdateManager.assertEquals((String)"pc2", (String)pc1.getRel().getSecondary());
        TestOperationOrderUpdateManager.assertNotNull((Object)pc1.getRel().getRel());
        TestOperationOrderUpdateManager.assertEquals((Object)pc1, (Object)pc1.getRel().getRel());
        em.close();
    }

    private OpOrder insertCircular() {
        OpOrderPCSub pc1 = new OpOrderPCSub();
        pc1.setSecondary("pc1");
        pc1.setSub("pcsub");
        OpOrderPCSub pc2 = new OpOrderPCSub();
        pc2.setSecondary("pc2");
        pc1.setRel(pc2);
        pc2.setRel(pc1);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        OpOrder oid = (OpOrder)em.find(OpOrder.class, (Object)pc1.getId());
        em.close();
        return oid;
    }

    private OpOrder insertCircularAutoAssign() {
        AutoIncrementOpOrderPCSub pc1 = new AutoIncrementOpOrderPCSub();
        pc1.setSecondary("pc1");
        pc1.setSub("pcsub");
        AutoIncrementOpOrderPCSub pc2 = new AutoIncrementOpOrderPCSub();
        pc2.setSecondary("pc2");
        pc1.setRel(pc2);
        pc2.setRel(pc1);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        this.endTx((EntityManager)em);
        OpOrder oid = (OpOrder)em.find(OpOrder.class, (Object)pc1.getId());
        em.close();
        return oid;
    }

    private void deleteCircularTest(boolean autoAssign) {
        OpOrder oid = autoAssign ? this.insertCircularAutoAssign() : this.insertCircular();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpOrder pc1 = (OpOrder)em.find(OpOrder.class, (Object)oid.getId());
        em.remove((Object)pc1.getRel());
        em.remove((Object)pc1);
        this.endTx((EntityManager)em);
        em.close();
    }

    private void deleteTest(boolean autoAssign) {
        OpOrder oid = autoAssign ? this.insertAutoAssign() : this.insert();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpOrder pc = (OpOrder)em.find(OpOrder.class, (Object)oid.getId());
        this.removeAll((EntityManager)em, pc.getMappedRelList());
        this.removeAll((EntityManager)em, pc.getInverseKeyRelList());
        this.removeAll((EntityManager)em, pc.getRelList());
        em.remove((Object)pc.getRel());
        em.remove((Object)pc);
        this.endTx((EntityManager)em);
        em.close();
    }

    public void testInsert() {
        this.insertTest(false);
    }

    public void testAutoAssignInsert() {
        this.insertTest(true);
    }

    public void testDeleteCircular() {
        this.deleteCircularTest(false);
    }

    public void testAutoAssignDeleteCircular() {
        this.deleteCircularTest(true);
    }

    public void testDelete() {
        this.deleteTest(false);
    }

    public void testAutoAssignDelete() {
        this.deleteTest(true);
    }

    public void testInsertCircularConstraint() {
        this.insertCircularConstraintTest(false);
    }

    public void testAutoAssignInsertCircularConstraint() {
        this.insertCircularConstraintTest(true);
    }

    private void persistAll(EntityManager em, List list) {
        for (Object o : list) {
            em.persist(o);
        }
    }

    private void removeAll(EntityManager em, List list) {
        for (Object o : list) {
            em.remove(o);
        }
    }
}

