/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.common.apps.ComplexEmbeddedPC;
import org.apache.openjpa.persistence.jdbc.common.apps.EmbeddedOwnerPC;
import org.apache.openjpa.persistence.jdbc.common.apps.EmbeddedPC;
import org.apache.openjpa.persistence.jdbc.common.apps.RecursivelyEmbeddedPC;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestEmbeddedPessimisticLocking
extends TestSQLListenerTestCase {
    private boolean supportsLocking;
    private Object oid;
    private OpenJPAEntityManagerFactory emf;

    public TestEmbeddedPessimisticLocking(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.emf = this.getEmf(this.getProps());
    }

    public void setUpTestCase() {
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.emf)).getConfiguration();
        this.supportsLocking = conf.getDBDictionaryInstance().supportsSelectForUpdate;
        this.deleteAll(EmbeddedOwnerPC.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbeddedOwnerPC owner = new EmbeddedOwnerPC(10, 20);
        em.persist((Object)owner);
        EmbeddedPC embedded = new EmbeddedPC();
        embedded.setIntField(4);
        embedded.setStringField("foo");
        owner.setEmbedded(embedded);
        EmbeddedPC embedded2 = new EmbeddedPC();
        embedded2.setIntField(8);
        embedded2.setStringField("bar");
        ComplexEmbeddedPC complex = new ComplexEmbeddedPC();
        complex.setStringField("complex");
        complex.setEmbedded(embedded2);
        owner.setComplexEmbedded(complex);
        this.endTx((EntityManager)em);
        this.oid = em.getObjectId((Object)owner);
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEMF(OpenJPAEntityManagerFactory emf) {
        OpenJPAEntityManager em = emf.createEntityManager();
        this.startTx((EntityManager)em);
        try {
            EmbeddedOwnerPC embeddedOwnerPC = (EmbeddedOwnerPC)em.getObjectId(this.oid);
        }
        finally {
            this.rollbackTx((EntityManager)em);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedFieldsWithLockedParent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.prepareEMF(em.getEntityManagerFactory());
        em.getFetchPlan().addField(EmbeddedOwnerPC.class, "embedded");
        this.startTx((EntityManager)em);
        try {
            sql.clear();
            EmbeddedOwnerPC pc = (EmbeddedOwnerPC)em.getObjectId(this.oid);
            TestEmbeddedPessimisticLocking.assertEquals((int)1, (int)sql.size());
            pc.getEmbedded().setStringField(pc.getEmbedded().getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTx((EntityManager)em);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedFieldsWithUnlockedParent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.prepareEMF(em.getEntityManagerFactory());
        em.getFetchPlan().addField(EmbeddedOwnerPC.class, "embedded");
        this.startTx((EntityManager)em);
        try {
            sql.clear();
            EmbeddedOwnerPC pc = (EmbeddedOwnerPC)em.getObjectId(this.oid);
            EmbeddedPC embedded = pc.getEmbedded();
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(pc, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(embedded, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertEquals((int)1, (int)sql.size());
            sql.clear();
            embedded.setStringField(embedded.getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
            TestEmbeddedPessimisticLocking.assertNotNull((Object)this.getStateManager(pc, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(embedded, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertTrue((boolean)this.getStateManager(pc, (EntityManager)em).isDirty());
            TestEmbeddedPessimisticLocking.assertTrue((boolean)this.getStateManager(embedded, (EntityManager)em).isDirty());
            pc.setStringField(pc.getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTx((EntityManager)em);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexEmbeddedFieldsWithLockedParent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.prepareEMF(em.getEntityManagerFactory());
        em.getFetchPlan().setMaxFetchDepth(-1);
        em.getFetchPlan().addField(EmbeddedOwnerPC.class, "complexEmbedded");
        em.getFetchPlan().addField(RecursivelyEmbeddedPC.class, "embedded");
        this.startTx((EntityManager)em);
        try {
            sql.clear();
            EmbeddedOwnerPC pc = (EmbeddedOwnerPC)em.getObjectId(this.oid);
            TestEmbeddedPessimisticLocking.assertEquals((int)1, (int)sql.size());
            pc.getComplexEmbedded().getEmbedded().setStringField(pc.getComplexEmbedded().getEmbedded().getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTx((EntityManager)em);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexEmbeddedFieldsWithUnlockedParent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.prepareEMF(em.getEntityManagerFactory());
        em.getFetchPlan().setMaxFetchDepth(-1);
        em.getFetchPlan().addField(EmbeddedOwnerPC.class, "complexEmbedded");
        em.getFetchPlan().addField(RecursivelyEmbeddedPC.class, "embedded");
        this.startTx((EntityManager)em);
        try {
            sql.clear();
            EmbeddedOwnerPC pc = (EmbeddedOwnerPC)em.getObjectId(this.oid);
            ComplexEmbeddedPC complex = pc.getComplexEmbedded();
            EmbeddedPC embedded = complex.getEmbedded();
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(pc, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(complex, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(embedded, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertEquals((int)1, (int)sql.size());
            sql.clear();
            embedded.setStringField(embedded.getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
            TestEmbeddedPessimisticLocking.assertNotNull((Object)this.getStateManager(pc, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(complex, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertNull((Object)this.getStateManager(embedded, (EntityManager)em).getLock());
            TestEmbeddedPessimisticLocking.assertTrue((boolean)this.getStateManager(pc, (EntityManager)em).isDirty());
            TestEmbeddedPessimisticLocking.assertTrue((boolean)this.getStateManager(complex, (EntityManager)em).isDirty());
            TestEmbeddedPessimisticLocking.assertTrue((boolean)this.getStateManager(embedded, (EntityManager)em).isDirty());
            complex.setStringField(complex.getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
            pc.setStringField(pc.getStringField() + "bar");
            TestEmbeddedPessimisticLocking.assertTrue((sql.size() <= 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTx((EntityManager)em);
            em.close();
        }
    }

    private Map getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DataCache", "true");
        props.put("openjpa.RemoteCommitProvider", "sjvm");
        props.put("openjpa.FlushBeforeQueries", "true");
        props.put("javax.jdo.option.IgnoreCache", "false");
        return props;
    }
}

