/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachA;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachB;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachC;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachD;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachE;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachF;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestEfficientAttach
extends TestSQLListenerTestCase {
    public TestEfficientAttach(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachWithDetachedStateManager() {
        int i;
        Class[] clss = new Class[]{AttachA.class, AttachB.class, AttachC.class, AttachD.class, AttachE.class, AttachF.class};
        String[] detachedStateFields = new String[clss.length];
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerSPI)kem).getConfiguration();
        MappingRepository repos = conf.getMappingRepositoryInstance();
        for (i = 0; i < clss.length; ++i) {
            ClassMetaData meta = repos.getMetaData(clss[i], null, true);
            detachedStateFields[i] = meta.getDetachedState();
            meta.setDetachedState(null);
            this.deleteAll(clss[i]);
        }
        try {
            this.attachTest();
        }
        finally {
            for (i = 0; i < clss.length; ++i) {
                repos.getMetaData(clss[i], null, true).setDetachedState(detachedStateFields[i]);
            }
        }
    }

    private void attachTest() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        AttachE e = new AttachE();
        e.setB(new AttachB());
        pm.persist((Object)e);
        this.endTx((EntityManager)pm);
    }

    public static void main(String[] args) {
    }
}

