/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.CircularFKPC;
import org.apache.openjpa.persistence.jdbc.common.apps.CircularFKPC2;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestCircularFK
extends BaseJDBCTest {
    private Object _oid1 = null;
    private Object _oid2 = null;

    public TestCircularFK(String name) {
        super(name);
    }

    public TestCircularFK() {
    }

    public void setUp() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        this.deleteAll(CircularFKPC.class, (EntityManager)pm);
        this.deleteAll(CircularFKPC2.class, (EntityManager)pm);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        CircularFKPC pc1 = new CircularFKPC();
        pc1.setStringField("pc1");
        CircularFKPC2 pc2 = new CircularFKPC2();
        pc2.setStringField("pc2");
        pc1.setFKField(pc2);
        pc2.setFKField(pc1);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        this.endTx((EntityManager)pm);
        this._oid1 = pm.getObjectId((Object)pc1);
        this._oid2 = pm.getObjectId((Object)pc2);
        this.endEm((EntityManager)pm);
    }

    public void testInsert() {
        OpenJPAEntityManager pm = this.getPM();
        CircularFKPC pc1 = (CircularFKPC)pm.find(CircularFKPC.class, this._oid1);
        CircularFKPC2 pc2 = (CircularFKPC2)pm.find(CircularFKPC2.class, this._oid2);
        TestCircularFK.assertNotNull((Object)pc1);
        TestCircularFK.assertNotNull((Object)pc2);
        TestCircularFK.assertEquals((String)"pc1", (String)pc1.getStringField());
        TestCircularFK.assertEquals((String)"pc2", (String)pc2.getStringField());
        TestCircularFK.assertEquals((Object)pc2, (Object)pc1.getFKField());
        TestCircularFK.assertEquals((Object)pc1, (Object)pc2.getFKField());
        pm.close();
    }

    public void testDelete() {
        OpenJPAEntityManager pm = this.getPM();
        CircularFKPC pc1 = (CircularFKPC)pm.find(CircularFKPC.class, this._oid1);
        CircularFKPC2 pc2 = (CircularFKPC2)pm.find(CircularFKPC2.class, this._oid2);
        this.startTx((EntityManager)pm);
        pm.remove((Object)pc1);
        pm.remove((Object)pc2);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        try {
            pm.find(CircularFKPC.class, this._oid1);
            TestCircularFK.fail((String)"PC1 still exists!");
        }
        catch (Exception jdse) {
            // empty catch block
        }
        try {
            pm.find(CircularFKPC2.class, this._oid2);
            TestCircularFK.fail((String)"PC2 still exists!");
        }
        catch (Exception jdse) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
    }

    public void testUpdate() {
        OpenJPAEntityManager pm = this.getPM();
        CircularFKPC pc1 = (CircularFKPC)pm.find(CircularFKPC.class, this._oid1);
        CircularFKPC2 pc2 = (CircularFKPC2)pm.find(CircularFKPC2.class, this._oid2);
        this.startTx((EntityManager)pm);
        CircularFKPC2 pc3 = new CircularFKPC2();
        pc3.setStringField("pc3");
        pc3.setFKField(pc1);
        pc1.setFKField(pc3);
        pc2.setFKField(null);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.getPM();
        pc1 = (CircularFKPC)pm.find(CircularFKPC.class, this._oid1);
        pc2 = (CircularFKPC2)pm.find(CircularFKPC2.class, this._oid2);
        TestCircularFK.assertNotNull((Object)pc1);
        TestCircularFK.assertNotNull((Object)pc2);
        TestCircularFK.assertEquals((String)"pc1", (String)pc1.getStringField());
        TestCircularFK.assertEquals((String)"pc2", (String)pc2.getStringField());
        TestCircularFK.assertNotNull((Object)pc1.getFKField());
        TestCircularFK.assertEquals((String)"pc3", (String)pc1.getFKField().getStringField());
        TestCircularFK.assertEquals((Object)pc1, (Object)pc1.getFKField().getFKField());
        TestCircularFK.assertNull((Object)pc2.getFKField());
    }
}

